/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.rpc.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.gwtplatform.dispatch.rpc.server.Dispatch;
import com.gwtplatform.dispatch.rpc.server.RequestProvider;
import com.gwtplatform.dispatch.rpc.shared.Action;
import com.gwtplatform.dispatch.rpc.shared.DispatchService;
import com.gwtplatform.dispatch.rpc.shared.Result;
import com.gwtplatform.dispatch.rpc.shared.ServiceException;
import com.gwtplatform.dispatch.shared.ActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractDispatchServiceImpl
extends RemoteServiceServlet
implements DispatchService {
    private static final long serialVersionUID = -4753225025940949024L;
    private static final String noSecurityCookieMessage = "You have to define a security cookie in order to use secured actions. See com.gwtplatform.dispatch.shared.SecurityCookie for details.";
    private static final String xsrfAttackMessage = "Cookie provided by RPC doesn't match request cookie, aborting action, possible XSRF attack. (Maybe you forgot to set the security cookie?)";
    protected final Dispatch dispatch;
    protected final Logger logger;
    protected final RequestProvider requestProvider;

    protected AbstractDispatchServiceImpl(Logger logger, Dispatch dispatch, RequestProvider requestProvider) {
        this.logger = logger;
        this.dispatch = dispatch;
        this.requestProvider = requestProvider;
    }

    public String getSecurityCookieName() {
        return null;
    }

    public Result execute(String cookieSentByRPC, Action<?> action) throws ActionException, ServiceException {
        if (action.isSecured() && !this.cookieMatch(cookieSentByRPC)) {
            String message = "Cookie provided by RPC doesn't match request cookie, aborting action, possible XSRF attack. (Maybe you forgot to set the security cookie?) While executing action: " + action.getClass().getName();
            this.logger.severe(message);
            throw new ServiceException(message);
        }
        try {
            return this.dispatch.execute(action);
        }
        catch (ActionException e) {
            if (this.logger.isLoggable(Level.WARNING)) {
                String newMessage = "Action exception while executing " + action.getClass().getName() + ": " + e.getMessage();
                this.logger.log(Level.WARNING, newMessage, e);
            }
            this.removeStacktraces(e);
            throw e;
        }
        catch (ServiceException e) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "Service exception while executing " + action.getClass().getName() + ": " + e.getMessage(), e);
            }
            throw new ServiceException(e.getMessage());
        }
        catch (RuntimeException e) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "Unexpected exception while executing " + action.getClass().getName() + ": " + "" + e.getMessage(), e);
            }
            throw new ServiceException(e.getMessage());
        }
    }

    public void undo(String cookieSentByRPC, Action<Result> action, Result result) throws ActionException, ServiceException {
        if (action.isSecured() && !this.cookieMatch(cookieSentByRPC)) {
            String message = "Cookie provided by RPC doesn't match request cookie, aborting action, possible XSRF attack. (Maybe you forgot to set the security cookie?) While undoing action: " + action.getClass().getName();
            this.logger.severe(message);
            throw new ServiceException(message);
        }
        try {
            this.dispatch.undo(action, result);
        }
        catch (ActionException e) {
            this.logger.warning("Action exception while undoing " + action.getClass().getName() + ": " + e.getMessage());
            throw new ActionException(e.getMessage());
        }
        catch (ServiceException e) {
            this.logger.warning("Service exception while undoing " + action.getClass().getName() + ": " + e.getMessage());
            throw new ServiceException(e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.warning("Unexpected exception while undoing " + action.getClass().getName() + ": " + e.getMessage());
            throw new ServiceException(e.getMessage());
        }
    }

    private boolean cookieMatch(String cookieSentByRPC) throws ServiceException {
        HttpServletRequest request = this.requestProvider.getServletRequest();
        if (this.getSecurityCookieName() == null) {
            this.logger.info(noSecurityCookieMessage);
            return false;
        }
        if (cookieSentByRPC == null) {
            this.logger.info("No cookie sent by client in RPC. (Did you forget to bind the security cookie client-side? Or it could be an attack.)");
            return false;
        }
        Cookie[] cookies = request.getCookies();
        String cookieInRequest = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(this.getSecurityCookieName())) continue;
                cookieInRequest = cookie.getValue();
                break;
            }
        }
        if (cookieInRequest == null) {
            this.logger.info("Cookie \"" + this.getSecurityCookieName() + "\" not found in HttpServletRequest!");
            return false;
        }
        return cookieInRequest.equals(cookieSentByRPC);
    }

    private void removeStacktraces(Throwable e) {
        if (e == null) {
            return;
        }
        e.setStackTrace(new StackTraceElement[0]);
        this.removeStacktraces(e.getCause());
    }
}

