/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.awt.color.ColorSpace;
import org.apache.fop.util.OCAColor;

public class OCAColorSpace
extends ColorSpace {
    private static final long serialVersionUID = 1L;

    protected OCAColorSpace() {
        super(5, 1);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        throw new UnsupportedOperationException("Color conversion from CIE XYZ to OCA is not possible");
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        throw new UnsupportedOperationException("Color conversion from RGB to OCA is not possible");
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        float[] rgb = this.toRGB(colorvalue);
        ColorSpace sRGB2 = ColorSpace.getInstance(1000);
        return sRGB2.toCIEXYZ(rgb);
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        int oca = (int)colorvalue[0];
        if (oca == OCAColor.OCAColorValue.BLACK.value) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        if (oca == OCAColor.OCAColorValue.BLUE.value) {
            return new float[]{0.0f, 0.0f, 1.0f};
        }
        if (oca == OCAColor.OCAColorValue.BROWN.value) {
            return new float[]{0.565f, 0.188f, 0.0f};
        }
        if (oca == OCAColor.OCAColorValue.CYAN.value) {
            return new float[]{0.0f, 1.0f, 1.0f};
        }
        if (oca == OCAColor.OCAColorValue.GREEN.value) {
            return new float[]{0.0f, 1.0f, 0.0f};
        }
        if (oca == OCAColor.OCAColorValue.MAGENTA.value) {
            return new float[]{1.0f, 0.0f, 1.0f};
        }
        if (oca == OCAColor.OCAColorValue.RED.value) {
            return new float[]{1.0f, 0.0f, 0.0f};
        }
        if (oca == OCAColor.OCAColorValue.YELLOW.value) {
            return new float[]{1.0f, 1.0f, 0.0f};
        }
        return null;
    }
}

