/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.csv.ExtendedBufferedReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExtendedBufferedReaderTest {
    @Test
    public void testEmptyInput() throws Exception {
        try (ExtendedBufferedReader br = this.createBufferedReader("");){
            Assertions.assertEquals((int)-1, (int)br.read());
            Assertions.assertEquals((int)-1, (int)br.lookAhead());
            Assertions.assertEquals((int)-1, (int)br.getLastChar());
            Assertions.assertNull((Object)br.readLine());
            Assertions.assertEquals((int)0, (int)br.read(new char[10], 0, 0));
        }
    }

    @Test
    public void testReadLookahead1() throws Exception {
        try (ExtendedBufferedReader br = this.createBufferedReader("1\n2\r3\n");){
            Assertions.assertEquals((long)0L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)49, (int)br.lookAhead());
            Assertions.assertEquals((int)-2, (int)br.getLastChar());
            Assertions.assertEquals((long)0L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)49, (int)br.read());
            Assertions.assertEquals((int)49, (int)br.getLastChar());
            Assertions.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)10, (int)br.lookAhead());
            Assertions.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)49, (int)br.getLastChar());
            Assertions.assertEquals((int)10, (int)br.read());
            Assertions.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)10, (int)br.getLastChar());
            Assertions.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)50, (int)br.lookAhead());
            Assertions.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)10, (int)br.getLastChar());
            Assertions.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)50, (int)br.read());
            Assertions.assertEquals((long)2L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)50, (int)br.getLastChar());
            Assertions.assertEquals((int)13, (int)br.lookAhead());
            Assertions.assertEquals((long)2L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)50, (int)br.getLastChar());
            Assertions.assertEquals((int)13, (int)br.read());
            Assertions.assertEquals((int)13, (int)br.getLastChar());
            Assertions.assertEquals((long)2L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)51, (int)br.lookAhead());
            Assertions.assertEquals((int)13, (int)br.getLastChar());
            Assertions.assertEquals((int)51, (int)br.read());
            Assertions.assertEquals((int)51, (int)br.getLastChar());
            Assertions.assertEquals((long)3L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)10, (int)br.lookAhead());
            Assertions.assertEquals((long)3L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)51, (int)br.getLastChar());
            Assertions.assertEquals((int)10, (int)br.read());
            Assertions.assertEquals((long)3L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)10, (int)br.getLastChar());
            Assertions.assertEquals((long)3L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)-1, (int)br.lookAhead());
            Assertions.assertEquals((int)10, (int)br.getLastChar());
            Assertions.assertEquals((int)-1, (int)br.read());
            Assertions.assertEquals((int)-1, (int)br.getLastChar());
            Assertions.assertEquals((int)-1, (int)br.read());
            Assertions.assertEquals((int)-1, (int)br.lookAhead());
            Assertions.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        }
    }

    @Test
    public void testReadLookahead2() throws Exception {
        char[] ref = new char[5];
        char[] res = new char[5];
        try (ExtendedBufferedReader br = this.createBufferedReader("abcdefg");){
            ref[0] = 97;
            ref[1] = 98;
            ref[2] = 99;
            Assertions.assertEquals((int)3, (int)br.read(res, 0, 3));
            Assertions.assertArrayEquals((char[])ref, (char[])res);
            Assertions.assertEquals((int)99, (int)br.getLastChar());
            Assertions.assertEquals((int)100, (int)br.lookAhead());
            ref[4] = 100;
            Assertions.assertEquals((int)1, (int)br.read(res, 4, 1));
            Assertions.assertArrayEquals((char[])ref, (char[])res);
            Assertions.assertEquals((int)100, (int)br.getLastChar());
        }
    }

    @Test
    public void testReadLine() throws Exception {
        try (ExtendedBufferedReader br = this.createBufferedReader("");){
            Assertions.assertNull((Object)br.readLine());
        }
        br = this.createBufferedReader("\n");
        var2_2 = null;
        try {
            Assertions.assertEquals((Object)"", (Object)br.readLine());
            Assertions.assertNull((Object)br.readLine());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var2_2 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        br = this.createBufferedReader("foo\n\nhello");
        var2_2 = null;
        try {
            Assertions.assertEquals((long)0L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((Object)"foo", (Object)br.readLine());
            Assertions.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((Object)"", (Object)br.readLine());
            Assertions.assertEquals((long)2L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((Object)"hello", (Object)br.readLine());
            Assertions.assertEquals((long)3L, (long)br.getCurrentLineNumber());
            Assertions.assertNull((Object)br.readLine());
            Assertions.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var2_2 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        br = this.createBufferedReader("foo\n\nhello");
        var2_2 = null;
        try {
            Assertions.assertEquals((int)102, (int)br.read());
            Assertions.assertEquals((int)111, (int)br.lookAhead());
            Assertions.assertEquals((Object)"oo", (Object)br.readLine());
            Assertions.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)10, (int)br.lookAhead());
            Assertions.assertEquals((Object)"", (Object)br.readLine());
            Assertions.assertEquals((long)2L, (long)br.getCurrentLineNumber());
            Assertions.assertEquals((int)104, (int)br.lookAhead());
            Assertions.assertEquals((Object)"hello", (Object)br.readLine());
            Assertions.assertNull((Object)br.readLine());
            Assertions.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var2_2 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        br = this.createBufferedReader("foo\rbaar\r\nfoo");
        var2_2 = null;
        try {
            Assertions.assertEquals((Object)"foo", (Object)br.readLine());
            Assertions.assertEquals((int)98, (int)br.lookAhead());
            Assertions.assertEquals((Object)"baar", (Object)br.readLine());
            Assertions.assertEquals((int)102, (int)br.lookAhead());
            Assertions.assertEquals((Object)"foo", (Object)br.readLine());
            Assertions.assertNull((Object)br.readLine());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var2_2 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
    }

    @Test
    public void testReadChar() throws Exception {
        String LF = "\n";
        String CR = "\r";
        String CRLF = "\r\n";
        String LFCR = "\n\r";
        String test = "a\nb\rc\n\nd\r\re\n\rf \r\n";
        int EOLeolct = 9;
        try (ExtendedBufferedReader br = this.createBufferedReader("a\nb\rc\n\nd\r\re\n\rf \r\n");){
            Assertions.assertEquals((long)0L, (long)br.getCurrentLineNumber());
            while (br.readLine() != null) {
            }
            Assertions.assertEquals((long)9L, (long)br.getCurrentLineNumber());
        }
        br = this.createBufferedReader("a\nb\rc\n\nd\r\re\n\rf \r\n");
        var8_8 = null;
        try {
            Assertions.assertEquals((long)0L, (long)br.getCurrentLineNumber());
            while (br.read() != -1) {
            }
            Assertions.assertEquals((long)9L, (long)br.getCurrentLineNumber());
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var8_8 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        br = this.createBufferedReader("a\nb\rc\n\nd\r\re\n\rf \r\n");
        var8_8 = null;
        try {
            Assertions.assertEquals((long)0L, (long)br.getCurrentLineNumber());
            char[] buff = new char[10];
            while (br.read(buff, 0, 3) != -1) {
            }
            Assertions.assertEquals((long)9L, (long)br.getCurrentLineNumber());
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var8_8 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
    }

    private ExtendedBufferedReader createBufferedReader(String s) {
        return new ExtendedBufferedReader((Reader)new StringReader(s));
    }
}

