/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Stack;

class DEROutputStream {
    private static final byte BOOLEAN_TAG = 1;
    private static final byte INTEGER_TAG = 2;
    private static final byte BIT_STRING_TAG = 3;
    private static final byte OCTET_STRING_TAG = 4;
    private static final byte NULL_TAG = 5;
    private static final byte OBJECT_IDENTIFIER_TAG = 6;
    private static final byte UTF8_STRING_TAG = 12;
    private static final byte PRINTABLE_STRING_TAG = 19;
    private static final byte T61_STRING_TAG = 20;
    private static final byte IA5_STRING_TAG = 22;
    private static final byte UTC_TIME_TAG = 23;
    private static final byte SEQUENCE_TAG = 48;
    private static final byte SET_TAG = 49;
    private static final byte IMPLICIT_TAG = -96;
    private OutputStream outputStream;
    private final Stack outputStreams = new Stack();

    public DEROutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeInteger(int i) throws IOException {
        this.outputStream.write(2);
        if (i << 24 >>> 24 == i) {
            this.outputStream.write(1);
            this.outputStream.write(i);
        } else if (i << 16 >>> 16 == i) {
            this.outputStream.write(2);
            this.outputStream.write(i >> 8);
            this.outputStream.write(i);
        } else if (i << 8 >>> 8 == i) {
            this.outputStream.write(3);
            this.outputStream.write(i >> 16);
            this.outputStream.write(i >> 8);
            this.outputStream.write(i);
        } else {
            this.outputStream.write(4);
            this.outputStream.write(i >> 24);
            this.outputStream.write(i >> 16);
            this.outputStream.write(i >> 8);
            this.outputStream.write(i);
        }
    }

    public void writeInteger(BigInteger bigInteger) throws IOException {
        byte[] bytes = bigInteger.toByteArray();
        this.write((byte)2, bytes);
    }

    public void writeOctetString(byte[] bytes) throws IOException {
        this.write((byte)4, bytes);
    }

    public void writeNull() throws IOException {
        this.outputStream.write(5);
        this.outputStream.write(0);
    }

    public void writeObjectIdentifier(byte[] bytes) throws IOException {
        this.write((byte)6, bytes);
    }

    public void writeString(String s, boolean asIA5String) throws IOException {
        if (asIA5String) {
            this.writeIA5String(s);
        } else if (this.isPrintable(s)) {
            this.writePrintableString(s);
        } else {
            this.writeUtf8String(s);
        }
    }

    public void writeUtf8String(String s) throws IOException {
        byte[] bytes = s.getBytes("UTF8");
        this.write((byte)12, bytes);
    }

    public void writeT61String(String s) throws IOException {
        byte[] bytes = s.getBytes("ASCII");
        this.write((byte)20, bytes);
    }

    public void writeIA5String(String s) throws IOException {
        byte[] bytes = s.getBytes("ASCII");
        this.write((byte)22, bytes);
    }

    public void writePrintableString(String s) throws IOException {
        byte[] bytes = s.getBytes("ASCII");
        this.write((byte)19, bytes);
    }

    private void writeLength(int i) throws IOException {
        if (i <= 127) {
            this.outputStream.write(i);
        } else if (i <= 255) {
            this.outputStream.write(129);
            this.outputStream.write(i);
        } else if (i <= 65535) {
            this.outputStream.write(130);
            this.outputStream.write(i >> 8);
            this.outputStream.write(i);
        } else if (i <= 0xFFFFFF) {
            this.outputStream.write(131);
            this.outputStream.write(i >> 16);
            this.outputStream.write(i >> 8);
            this.outputStream.write(i);
        } else {
            this.outputStream.write(132);
            this.outputStream.write(i >> 24);
            this.outputStream.write(i >> 16);
            this.outputStream.write(i >> 8);
            this.outputStream.write(i);
        }
    }

    public void startSequence() throws IOException {
        this.pushOutputStream();
    }

    public void endSequence() throws IOException {
        byte[] bytes = this.popOutputStream();
        this.writeSequence(bytes);
    }

    private void writeSequence(byte[] bytes) throws IOException {
        this.write((byte)48, bytes);
    }

    public void startSet() throws IOException {
        this.pushOutputStream();
    }

    public void endSet() throws IOException {
        byte[] bytes = this.popOutputStream();
        this.writeSet(bytes);
    }

    private void writeSet(byte[] bytes) throws IOException {
        this.write((byte)49, bytes);
    }

    public void startImplicit() throws IOException {
        this.pushOutputStream();
    }

    public void endImplicit() throws IOException {
        byte[] bytes = this.popOutputStream();
        this.writeImplicit(bytes);
    }

    public void writeImplicit(byte[] bytes) throws IOException {
        this.write((byte)-96, bytes);
    }

    public void write(byte tag, byte[] bytes) throws IOException {
        this.outputStream.write(tag);
        this.writeLength(bytes.length);
        this.outputStream.write(bytes);
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void close() throws IOException {
        if (!this.outputStreams.isEmpty()) {
            throw new IllegalStateException("DER sequences/sets not ended properly");
        }
        this.outputStream.close();
    }

    private boolean isPrintable(String s) {
        for (int index = 0; index < s.length(); ++index) {
            char c = s.charAt(index);
            if (c >= ' ' && c < '\u0080') continue;
            return false;
        }
        return true;
    }

    private void pushOutputStream() {
        this.outputStreams.push(this.outputStream);
        this.outputStream = new ByteArrayOutputStream();
    }

    private byte[] popOutputStream() {
        byte[] bytes = ((ByteArrayOutputStream)this.outputStream).toByteArray();
        this.outputStream = (OutputStream)this.outputStreams.pop();
        return bytes;
    }
}

