/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.util.jsonprinter;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import proguard.evaluation.util.jsonprinter.BranchTargetRecord;
import proguard.evaluation.util.jsonprinter.InstructionBlockEvaluationRecord;
import proguard.evaluation.util.jsonprinter.JsonPrinter;
import proguard.evaluation.util.jsonprinter.JsonSerializable;

class InstructionEvaluationRecord
implements JsonSerializable {
    private final boolean skipEvaluation;
    private final boolean isGeneralization;
    private final int evaluationCount;
    @NotNull
    private final String instruction;
    private final int instructionOffset;
    private List<BranchTargetRecord> updatedEvaluationStack;
    @NotNull
    private final List<String> variablesBefore;
    @NotNull
    private final List<String> stackBefore;
    private List<InstructionBlockEvaluationRecord> jsrBlockEvaluations;

    public InstructionEvaluationRecord(Boolean skipEvaluation, Boolean isGeneralization, Integer evaluationCount, @NotNull String instruction, Integer instructionOffset, @NotNull List<String> variablesBefore, @NotNull List<String> stackBefore) {
        this.skipEvaluation = skipEvaluation;
        this.isGeneralization = isGeneralization;
        this.evaluationCount = evaluationCount;
        this.instruction = instruction;
        this.instructionOffset = instructionOffset;
        this.variablesBefore = variablesBefore;
        this.stackBefore = stackBefore;
    }

    @Override
    public StringBuilder toJson(StringBuilder builder) {
        builder.append("{");
        JsonPrinter.toJson("skipEvaluation", this.skipEvaluation, builder).append(",");
        JsonPrinter.toJson("isGeneralization", this.isGeneralization, builder).append(",");
        JsonPrinter.toJson("evaluationCount", this.evaluationCount, builder).append(",");
        JsonPrinter.toJson("instruction", this.instruction, builder).append(",");
        JsonPrinter.toJson("instructionOffset", this.instructionOffset, builder).append(",");
        JsonPrinter.stringListToJson("variablesBefore", this.variablesBefore, builder).append(",");
        JsonPrinter.stringListToJson("stackBefore", this.stackBefore, builder);
        if (this.updatedEvaluationStack != null) {
            builder.append(",");
            JsonPrinter.listToJson("updatedEvaluationStack", this.updatedEvaluationStack, builder);
        }
        if (this.jsrBlockEvaluations != null) {
            builder.append(",");
            JsonPrinter.listToJson("jsrBlockEvaluations", this.jsrBlockEvaluations, builder);
        }
        return builder.append("}");
    }

    public void setUpdatedEvaluationStack(List<BranchTargetRecord> updatedEvaluationStack) {
        this.updatedEvaluationStack = updatedEvaluationStack;
    }

    public void setJsrBlockEvaluations(List<InstructionBlockEvaluationRecord> jsrBlockEvaluations) {
        this.jsrBlockEvaluations = jsrBlockEvaluations;
    }

    public boolean isSkipEvaluation() {
        return this.skipEvaluation;
    }

    public boolean isGeneralization() {
        return this.isGeneralization;
    }

    public int getEvaluationCount() {
        return this.evaluationCount;
    }

    @NotNull
    public String getInstruction() {
        return this.instruction;
    }

    public int getInstructionOffset() {
        return this.instructionOffset;
    }

    public List<BranchTargetRecord> getUpdatedEvaluationStack() {
        return this.updatedEvaluationStack;
    }

    @NotNull
    public List<String> getVariablesBefore() {
        return this.variablesBefore;
    }

    @NotNull
    public List<String> getStackBefore() {
        return this.stackBefore;
    }

    public List<InstructionBlockEvaluationRecord> getJsrBlockEvaluations() {
        return this.jsrBlockEvaluations;
    }
}

