/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.function.Predicate;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.visitor.MemberVisitor;

public class MemberProcessingInfoFilter
implements MemberVisitor {
    private final Predicate<Object> predicate;
    private final MemberVisitor acceptedMemberVisitor;
    private final MemberVisitor rejectedMemberVisitor;

    public MemberProcessingInfoFilter(Predicate<Object> predicate, MemberVisitor acceptedMemberVisitor) {
        this(predicate, acceptedMemberVisitor, null);
    }

    public MemberProcessingInfoFilter(Predicate<Object> predicate, MemberVisitor acceptedMemberVisitor, MemberVisitor rejectedMemberVisitor) {
        this.predicate = predicate;
        this.acceptedMemberVisitor = acceptedMemberVisitor;
        this.rejectedMemberVisitor = rejectedMemberVisitor;
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
        MemberVisitor delegate = this.getDelegate(member);
        if (delegate != null) {
            member.accept(clazz, delegate);
        }
    }

    private MemberVisitor getDelegate(Member member) {
        return this.predicate.test(member.getProcessingInfo()) ? this.acceptedMemberVisitor : this.rejectedMemberVisitor;
    }
}

