/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.inject.argument;

import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.inject.argument.InjectedArgument;

public class ConstantPrimitive
implements InjectedArgument {
    private final Object primitive;

    public ConstantPrimitive(Object primitive) {
        this.primitive = primitive;
    }

    @Override
    public Object getValue() {
        return this.primitive;
    }

    @Override
    public String getInternalType() {
        switch (this.primitive.getClass().getName()) {
            case "java.lang.Boolean": {
                return "Z";
            }
            case "java.lang.Byte": {
                return "B";
            }
            case "java.lang.Character": {
                return "C";
            }
            case "java.lang.Short": {
                return "S";
            }
            case "java.lang.Integer": {
                return "I";
            }
            case "java.lang.Long": {
                return "J";
            }
            case "java.lang.Float": {
                return "F";
            }
            case "java.lang.Double": {
                return "D";
            }
        }
        throw new RuntimeException("Unexpected type");
    }

    public String toString() {
        return this.primitive.toString() + ":" + ClassUtil.externalType(this.getInternalType());
    }
}

