/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin;

import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.FieldSignature;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.flags.KotlinPropertyAccessorFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyFlags;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinVersionRequirementVisitor;
import proguard.exception.ProguardCoreException;
import proguard.util.SimpleProcessable;

public class KotlinPropertyMetadata
extends SimpleProcessable {
    public String name;
    public List<KotlinTypeParameterMetadata> typeParameters;
    public KotlinTypeMetadata receiverType;
    public List<KotlinTypeMetadata> contextReceivers;
    @Deprecated
    public List<KotlinValueParameterMetadata> setterParameters;
    public KotlinValueParameterMetadata setterParameter;
    public KotlinTypeMetadata type;
    public KotlinVersionRequirementMetadata versionRequirement;
    public KotlinPropertyFlags flags;
    public KotlinPropertyAccessorFlags getterFlags;
    public KotlinPropertyAccessorFlags setterFlags;
    public FieldSignature backingFieldSignature;
    public Clazz referencedBackingFieldClass;
    public Field referencedBackingField;
    public MethodSignature getterSignature;
    public Method referencedGetterMethod;
    public MethodSignature setterSignature;
    public Method referencedSetterMethod;
    public MethodSignature syntheticMethodForAnnotations;
    public Clazz referencedSyntheticMethodClass;
    public Method referencedSyntheticMethodForAnnotations;
    public MethodSignature syntheticMethodForDelegate;
    public Clazz referencedSyntheticMethodForDelegateClass;
    public Method referencedSyntheticMethodForDelegateMethod;

    public KotlinPropertyMetadata(KotlinPropertyFlags flags, String name, KotlinPropertyAccessorFlags getterFlags, KotlinPropertyAccessorFlags setterFlags) {
        this.name = name;
        this.flags = flags;
        this.getterFlags = getterFlags;
        this.setterFlags = setterFlags;
    }

    public void accept(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyVisitor kotlinPropertyVisitor) {
        kotlinPropertyVisitor.visitProperty(clazz, kotlinDeclarationContainerMetadata, this);
    }

    void acceptAsDelegated(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyVisitor kotlinPropertyVisitor) {
        kotlinPropertyVisitor.visitDelegatedProperty(clazz, kotlinDeclarationContainerMetadata, this);
    }

    public void typeAccept(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeVisitor kotlinTypeVisitor) {
        if (this.type == null) {
            throw new ProguardCoreException.Builder("Property type is null in class %s.", 11000).errorParameters(clazz.getName()).build();
        }
        kotlinTypeVisitor.visitPropertyType(clazz, kotlinDeclarationContainerMetadata, this, this.type);
    }

    public void receiverTypeAccept(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeVisitor kotlinTypeVisitor) {
        if (this.receiverType != null) {
            kotlinTypeVisitor.visitPropertyReceiverType(clazz, kotlinDeclarationContainerMetadata, this, this.receiverType);
        }
    }

    public void contextReceiverTypesAccept(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinTypeVisitor kotlinTypeVisitor) {
        if (this.contextReceivers != null) {
            for (KotlinTypeMetadata contextReceiver : this.contextReceivers) {
                kotlinTypeVisitor.visitPropertyContextReceiverType(clazz, kotlinMetadata, this, contextReceiver);
            }
        }
    }

    @Deprecated
    public void setterParametersAccept(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinValueParameterVisitor kotlinValueParameterVisitor) {
        this.setterParameterAccept(clazz, kotlinDeclarationContainerMetadata, kotlinValueParameterVisitor);
    }

    public void setterParameterAccept(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinValueParameterVisitor kotlinValueParameterVisitor) {
        if (this.setterParameter != null) {
            this.setterParameter.accept(clazz, kotlinDeclarationContainerMetadata, this, kotlinValueParameterVisitor);
        }
    }

    public void typeParametersAccept(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeParameterVisitor kotlinTypeParameterVisitor) {
        if (this.typeParameters == null) {
            throw new ProguardCoreException.Builder("Type parameters are null in class %s.", 11000).errorParameters(clazz.getName()).build();
        }
        for (KotlinTypeParameterMetadata typeParameter : this.typeParameters) {
            typeParameter.accept(clazz, kotlinDeclarationContainerMetadata, this, kotlinTypeParameterVisitor);
        }
    }

    public void versionRequirementAccept(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinVersionRequirementVisitor kotlinVersionRequirementVisitor) {
        if (this.versionRequirement != null) {
            this.versionRequirement.accept(clazz, kotlinDeclarationContainerMetadata, this, kotlinVersionRequirementVisitor);
        }
    }

    public String toString() {
        return "Kotlin " + (this.flags.isDelegated ? "delegated " : "") + "property (" + this.name + " | " + (this.backingFieldSignature != null ? "b" : "") + "g" + (this.getterFlags.isDefault ? "" : "+") + (this.flags.isVar ? "s" + (this.setterFlags.isDefault ? "" : "+") : "") + ")";
    }
}

