/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.peephole.ClassMerger;

public class WrapperClassUseSimplifier
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
ClassVisitor {
    private static final Logger logger = LogManager.getLogger(WrapperClassUseSimplifier.class);
    private final InstructionVisitor extraInstructionVisitor;
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, true);
    private Clazz wrappedClass;
    private boolean isDupedOnStack;
    private Instruction storeInstruction;

    public WrapperClassUseSimplifier() {
        this(null);
    }

    public WrapperClassUseSimplifier(InstructionVisitor extraInstructionVisitor) {
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        logger.debug("WrapperClassUseSimplifier: {}.{}{}", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
        int codeLength = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(codeLength);
        codeAttribute.instructionsAccept(clazz, method, (InstructionVisitor)this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -69: {
                if (!this.isReferencingWrapperClass(clazz, constantInstruction.constantIndex)) break;
                this.codeAttributeEditor.deleteInstruction(offset);
                offset += constantInstruction.length(offset);
                Instruction nextInstruction = InstructionFactory.create((byte[])codeAttribute.code, (int)offset);
                boolean bl = this.isDupedOnStack = nextInstruction.opcode == 89;
                if (this.isDupedOnStack) {
                    this.codeAttributeEditor.deleteInstruction(offset);
                    offset += nextInstruction.length(offset);
                    nextInstruction = InstructionFactory.create((byte[])codeAttribute.code, (int)offset);
                }
                if (nextInstruction.canonicalOpcode() == 58) {
                    this.codeAttributeEditor.deleteInstruction(offset);
                    this.storeInstruction = nextInstruction;
                    offset += nextInstruction.length(offset);
                    nextInstruction = InstructionFactory.create((byte[])codeAttribute.code, (int)offset);
                    if (nextInstruction.canonicalOpcode() == 25 && ((VariableInstruction)this.storeInstruction).variableIndex == ((VariableInstruction)nextInstruction).variableIndex) {
                        this.codeAttributeEditor.deleteInstruction(offset);
                        this.isDupedOnStack = true;
                    }
                } else {
                    this.storeInstruction = null;
                }
                if (this.extraInstructionVisitor == null) break;
                this.extraInstructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
                break;
            }
            case -73: {
                if (!this.isReferencingWrapperClass(clazz, constantInstruction.constantIndex)) break;
                if (this.storeInstruction != null) {
                    this.codeAttributeEditor.replaceInstruction(offset, this.storeInstruction);
                    break;
                }
                if (this.isDupedOnStack) {
                    this.codeAttributeEditor.deleteInstruction(offset);
                    break;
                }
                this.codeAttributeEditor.replaceInstruction(offset, (Instruction)new SimpleInstruction(87));
                break;
            }
            case -76: {
                if (!this.isReferencingWrapperClass(clazz, constantInstruction.constantIndex)) break;
                this.codeAttributeEditor.deleteInstruction(offset);
            }
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        fieldrefConstant.referencedClassAccept((ClassVisitor)this);
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        if (methodrefConstant.getName(clazz).equals("<init>")) {
            methodrefConstant.referencedClassAccept((ClassVisitor)this);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept((ClassVisitor)this);
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.wrappedClass = ClassMerger.getTargetClass((Clazz)programClass);
    }

    private boolean isReferencingWrapperClass(Clazz clazz, int constantIndex) {
        this.wrappedClass = null;
        clazz.constantPoolEntryAccept(constantIndex, (ConstantVisitor)this);
        return this.wrappedClass != null;
    }
}

