/*
 * Decompiled with CFR 0.152.
 */
package proguard.strip;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.AnnotationsAttributeEditor;
import proguard.classfile.kotlin.visitor.KotlinMetadataRemover;
import proguard.classfile.kotlin.visitor.filter.KotlinClassFilter;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.CounterConditionalClassVisitor;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberProcessingFlagFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.util.Counter;
import proguard.util.ProcessingFlagSetter;

public class KotlinAnnotationStripper {
    private static final Logger logger = LogManager.getLogger(KotlinAnnotationStripper.class);

    public void execute(Configuration configuration, ClassPool programClassPool, ClassPool libraryClassPool) {
        logger.info("Removing @kotlin.Metadata annotation where not kept...");
        ClassCounter originalCounter = new ClassCounter();
        MemberCounter keptMemberCounter = new MemberCounter();
        MyKotlinAnnotationStripper kotlinAnnotationStripper = new MyKotlinAnnotationStripper();
        MultiClassVisitor kotlinAnnotationStripperVisitor = new MultiClassVisitor(new ClassVisitor[]{new KotlinClassFilter((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{originalCounter, new CounterConditionalClassVisitor((Counter)keptMemberCounter, CounterConditionalClassVisitor::isSame, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberProcessingFlagFilter(0x700000, 0, (MemberVisitor)keptMemberCounter)), (ClassVisitor)new ClassProcessingFlagFilter(0, 0x700000, (ClassVisitor)kotlinAnnotationStripper))})), new KotlinClassFilter((ClassVisitor)new ProcessingFlagSetter(0x200000))});
        programClassPool.classesAccept((ClassVisitor)kotlinAnnotationStripperVisitor);
        libraryClassPool.classesAccept((ClassVisitor)kotlinAnnotationStripperVisitor);
        logger.info("  Original number of classes with @kotlin.Metadata:            {}", (Object)originalCounter.getCount());
        logger.info("  Final number of classes with @kotlin.Metadata:               {}", (Object)(originalCounter.getCount() - kotlinAnnotationStripper.getCount()));
    }

    private static class MyKotlinAnnotationStripper
    implements ClassVisitor,
    AttributeVisitor,
    AnnotationVisitor {
        private final KotlinMetadataRemover kotlinMetadataRemover = new KotlinMetadataRemover();
        private AnnotationsAttributeEditor attributesEditor;
        private int count = 0;

        private MyKotlinAnnotationStripper() {
        }

        public int getCount() {
            return this.count;
        }

        public void visitAnyClass(Clazz clazz) {
            clazz.attributesAccept((AttributeVisitor)this);
        }

        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
            this.attributesEditor = new AnnotationsAttributeEditor((AnnotationsAttribute)runtimeVisibleAnnotationsAttribute);
            runtimeVisibleAnnotationsAttribute.annotationsAccept(clazz, (AnnotationVisitor)new AnnotationTypeFilter("Lkotlin/Metadata;", (AnnotationVisitor)this));
        }

        public void visitAnnotation(Clazz clazz, Annotation annotation) {
            logger.debug("Removing Kotlin metadata annotation from {}", (Object)clazz.getName());
            this.attributesEditor.deleteAnnotation(annotation);
            clazz.accept((ClassVisitor)this.kotlinMetadataRemover);
            ++this.count;
        }
    }
}

