/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberToClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.OptimizationInfoClassFilter;
import proguard.optimize.info.SimpleEnumMarker;

public class SimpleEnumClassChecker
implements ClassVisitor {
    private static final Logger logger = LogManager.getLogger(SimpleEnumClassChecker.class);
    private final ClassVisitor simpleEnumMarker = new OptimizationInfoClassFilter(new SimpleEnumMarker(true));
    private final MemberVisitor instanceMemberChecker = new MemberAccessFilter(0, 8, (MemberVisitor)new MemberToClassVisitor((ClassVisitor)new SimpleEnumMarker(false)));

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (programClass.findMethod("<init>", "(Ljava/lang/String;I)V") != null) {
            logger.debug("SimpleEnumClassChecker: [{}] is a candidate simple enum, without extra fields", (Object)programClass.getName());
            this.simpleEnumMarker.visitProgramClass(programClass);
            programClass.fieldsAccept(this.instanceMemberChecker);
            programClass.methodsAccept(this.instanceMemberChecker);
        }
    }
}

