/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVersionSetter;
import proguard.classfile.visitor.ClassVisitor;

public class Targeter {
    private static final Logger logger = LogManager.getLogger(Targeter.class);
    private final Configuration configuration;

    public Targeter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool) throws IOException {
        HashSet newerClassVersions = this.configuration.warn != null ? null : new HashSet();
        programClassPool.classesAccept((ClassVisitor)new ClassVersionSetter(this.configuration.targetClassVersion, newerClassVersions));
        if (newerClassVersions != null && newerClassVersions.size() > 0) {
            logger.error("Warning: some classes have more recent versions (");
            Iterator iterator = newerClassVersions.iterator();
            while (iterator.hasNext()) {
                Integer classVersion = (Integer)iterator.next();
                logger.error(ClassUtil.externalClassVersion((int)classVersion));
                if (!iterator.hasNext()) continue;
                logger.error(",");
            }
            logger.error(")");
            logger.error("         than the target version ({}).", (Object)ClassUtil.externalClassVersion((int)this.configuration.targetClassVersion));
            if (!this.configuration.ignoreWarnings) {
                logger.error("         If you are sure this is not a problem,");
                logger.error("         you could try your luck using the '-ignorewarnings' option.");
                throw new IOException("Please correct the above warnings first.");
            }
        }
    }
}

