/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.ClassMemberChecker;
import proguard.Configuration;
import proguard.DescriptorKeepChecker;
import proguard.FullyQualifiedClassNameChecker;
import proguard.GetAnnotationChecker;
import proguard.GetEnclosingClassChecker;
import proguard.GetEnclosingMethodChecker;
import proguard.GetSignatureChecker;
import proguard.KeepClassSpecification;
import proguard.LibraryKeepChecker;
import proguard.MemberSpecification;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AllElementValueVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.DynamicClassReferenceInitializer;
import proguard.classfile.util.DynamicMemberReferenceInitializer;
import proguard.classfile.util.EnumFieldReferenceInitializer;
import proguard.classfile.util.StringReferenceInitializer;
import proguard.classfile.util.StringSharer;
import proguard.classfile.util.WarningLogger;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.util.kotlin.KotlinMetadataInitializer;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.LibraryClassFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.resources.file.ResourceFilePool;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.file.visitor.ResourceJavaReferenceClassInitializer;
import proguard.resources.kotlinmodule.util.KotlinModuleReferenceInitializer;
import proguard.util.ClassNameParser;
import proguard.util.EmptyStringMatcher;
import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.StringMatcher;
import proguard.util.StringParser;
import proguard.util.kotlin.asserter.KotlinMetadataAsserter;

public class Initializer {
    private static final Logger logger = LogManager.getLogger(Initializer.class);
    private final Configuration configuration;
    private final boolean checkConfiguration;

    public Initializer(Configuration configuration) {
        this.configuration = configuration;
        this.checkConfiguration = configuration.shrink || configuration.optimize || configuration.obfuscate;
    }

    public void execute(ClassPool programClassPool, ClassPool libraryClassPool, ResourceFilePool resourceFilePool) throws IOException {
        boolean incompatibleOptimization;
        int kotlinInitializationWarningCount;
        int libraryMemberReferenceWarningCount;
        int programMemberReferenceWarningCount;
        int dependencyWarningCount;
        int classReferenceWarningCount;
        int getmemberNoteCount;
        int classForNameNoteCount;
        int dynamicClassReferenceNoteCount;
        int libraryNoteCount;
        int descriptorNoteCount;
        int getEnclosingMethodNoteCount;
        int getEnclosingClassNoteCount;
        int getSignatureNoteCount;
        int getAnnotationNoteCount;
        int classMemberNoteCount;
        int originalLibraryClassPoolSize = libraryClassPool.size();
        WarningLogger fullyQualifiedClassNameNotePrinter = new WarningLogger(logger, this.configuration.note);
        if (this.checkConfiguration) {
            FullyQualifiedClassNameChecker fullyQualifiedClassNameChecker = new FullyQualifiedClassNameChecker(programClassPool, libraryClassPool, (WarningPrinter)fullyQualifiedClassNameNotePrinter);
            fullyQualifiedClassNameChecker.checkClassSpecifications(this.configuration.keep);
            fullyQualifiedClassNameChecker.checkClassSpecifications(this.configuration.assumeNoSideEffects);
            fullyQualifiedClassNameChecker.checkClassSpecifications(this.configuration.assumeNoExternalSideEffects);
            fullyQualifiedClassNameChecker.checkClassSpecifications(this.configuration.assumeNoEscapingParameters);
            fullyQualifiedClassNameChecker.checkClassSpecifications(this.configuration.assumeNoExternalReturnValues);
        }
        EmptyStringMatcher keepAttributesMatcher = this.configuration.keepAttributes != null ? new ListParser((StringParser)new NameParser()).parse(this.configuration.keepAttributes) : new EmptyStringMatcher();
        WarningLogger getAnnotationNotePrinter = new WarningLogger(logger, this.configuration.note);
        if (!keepAttributesMatcher.matches("RuntimeVisibleAnnotations")) {
            programClassPool.classesAccept((ClassVisitor)new AllConstantVisitor((ConstantVisitor)new GetAnnotationChecker((WarningPrinter)getAnnotationNotePrinter)));
        }
        WarningLogger getSignatureNotePrinter = new WarningLogger(logger, this.configuration.note);
        if (!keepAttributesMatcher.matches("Signature")) {
            programClassPool.classesAccept((ClassVisitor)new AllConstantVisitor((ConstantVisitor)new GetSignatureChecker((WarningPrinter)getSignatureNotePrinter)));
        }
        WarningLogger getEnclosingClassNotePrinter = new WarningLogger(logger, this.configuration.note);
        if (!keepAttributesMatcher.matches("InnerClasses")) {
            programClassPool.classesAccept((ClassVisitor)new AllConstantVisitor((ConstantVisitor)new GetEnclosingClassChecker((WarningPrinter)getEnclosingClassNotePrinter)));
        }
        WarningLogger getEnclosingMethodNotePrinter = new WarningLogger(logger, this.configuration.note);
        if (!keepAttributesMatcher.matches("EnclosingMethod")) {
            programClassPool.classesAccept((ClassVisitor)new AllConstantVisitor((ConstantVisitor)new GetEnclosingMethodChecker((WarningPrinter)getEnclosingMethodNotePrinter)));
        }
        ClassPool reducedLibraryClassPool = this.configuration.useUniqueClassMemberNames ? null : new ClassPool();
        WarningLogger classReferenceWarningPrinter = new WarningLogger(logger, this.configuration.warn);
        WarningLogger dependencyWarningPrinter = new WarningLogger(logger, this.configuration.warn);
        programClassPool.classesAccept((ClassVisitor)new ClassSuperHierarchyInitializer(programClassPool, libraryClassPool, (WarningPrinter)classReferenceWarningPrinter, null));
        libraryClassPool.classesAccept((ClassVisitor)new ClassSuperHierarchyInitializer(programClassPool, libraryClassPool, null, (WarningPrinter)dependencyWarningPrinter));
        WarningLogger kotlinInitializationWarningPrinter = new WarningLogger(logger, this.configuration.warn);
        if (this.configuration.keepKotlinMetadata) {
            AllAttributeVisitor kotlinMetadataInitializer = new AllAttributeVisitor((AttributeVisitor)new AttributeNameFilter("RuntimeVisibleAnnotations", (AttributeVisitor)new AllAnnotationVisitor((AnnotationVisitor)new AnnotationTypeFilter("Lkotlin/Metadata;", (AnnotationVisitor)new KotlinMetadataInitializer((WarningPrinter)kotlinInitializationWarningPrinter)))));
            programClassPool.classesAccept((ClassVisitor)kotlinMetadataInitializer);
            libraryClassPool.classesAccept((ClassVisitor)kotlinMetadataInitializer);
        }
        WarningLogger programMemberReferenceWarningPrinter = new WarningLogger(logger, this.configuration.warn);
        WarningLogger libraryMemberReferenceWarningPrinter = new WarningLogger(logger, this.configuration.warn);
        programClassPool.classesAccept((ClassVisitor)new ClassReferenceInitializer(programClassPool, libraryClassPool, (WarningPrinter)classReferenceWarningPrinter, (WarningPrinter)programMemberReferenceWarningPrinter, (WarningPrinter)libraryMemberReferenceWarningPrinter, null));
        if (reducedLibraryClassPool != null) {
            programClassPool.classesAccept((ClassVisitor)new ReferencedClassVisitor(true, (ClassVisitor)new LibraryClassFilter((ClassVisitor)new ClassPoolFiller(reducedLibraryClassPool))));
            reducedLibraryClassPool.classesAccept((ClassVisitor)new ClassSuperHierarchyInitializer(programClassPool, libraryClassPool, (WarningPrinter)classReferenceWarningPrinter, null));
        }
        programClassPool.classesAccept((ClassVisitor)new AllAttributeVisitor(true, (AttributeVisitor)new AllElementValueVisitor(true, (ElementValueVisitor)new EnumFieldReferenceInitializer())));
        WarningLogger dynamicClassReferenceNotePrinter = new WarningLogger(logger, this.configuration.note);
        WarningLogger classForNameNotePrinter = new WarningLogger(logger, this.configuration.note);
        programClassPool.classesAccept((ClassVisitor)new AllMethodVisitor((MemberVisitor)new AllAttributeVisitor((AttributeVisitor)new AllInstructionVisitor((InstructionVisitor)new DynamicClassReferenceInitializer(programClassPool, libraryClassPool, (WarningPrinter)dynamicClassReferenceNotePrinter, null, (WarningPrinter)classForNameNotePrinter, this.createClassNoteExceptionMatcher(this.configuration.keep, true))))));
        WarningLogger getMemberNotePrinter = new WarningLogger(logger, this.configuration.note);
        programClassPool.classesAccept((ClassVisitor)new AllMethodVisitor((MemberVisitor)new AllAttributeVisitor((AttributeVisitor)new DynamicMemberReferenceInitializer(programClassPool, libraryClassPool, (WarningPrinter)getMemberNotePrinter, this.createClassMemberNoteExceptionMatcher(this.configuration.keep, true), this.createClassMemberNoteExceptionMatcher(this.configuration.keep, false)))));
        if (this.configuration.adaptClassStrings != null) {
            programClassPool.classesAccept((ClassVisitor)new ClassNameFilter(this.configuration.adaptClassStrings, (ClassVisitor)new AllConstantVisitor((ConstantVisitor)new StringReferenceInitializer(programClassPool, libraryClassPool))));
        }
        if (reducedLibraryClassPool != null) {
            programClassPool.classesAccept((ClassVisitor)new ReferencedClassVisitor((ClassVisitor)new LibraryClassFilter((ClassVisitor)new ClassHierarchyTraveler(true, true, true, false, (ClassVisitor)new LibraryClassFilter((ClassVisitor)new ClassPoolFiller(reducedLibraryClassPool))))));
            reducedLibraryClassPool.classesAccept((ClassVisitor)new ClassReferenceInitializer(programClassPool, libraryClassPool, null, null, null, (WarningPrinter)dependencyWarningPrinter));
            libraryClassPool.clear();
            reducedLibraryClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ClassHierarchyTraveler(true, true, true, false, (ClassVisitor)new LibraryClassFilter((ClassVisitor)new ClassPoolFiller(libraryClassPool))), new ReferencedClassVisitor((ClassVisitor)new LibraryClassFilter((ClassVisitor)new ClassHierarchyTraveler(true, true, true, false, (ClassVisitor)new LibraryClassFilter((ClassVisitor)new ClassPoolFiller(libraryClassPool)))))}));
        } else {
            libraryClassPool.classesAccept((ClassVisitor)new ClassReferenceInitializer(programClassPool, libraryClassPool, null, null, null, (WarningPrinter)dependencyWarningPrinter));
        }
        ClassSubHierarchyInitializer classSubHierarchyInitializer = new ClassSubHierarchyInitializer();
        programClassPool.accept((ClassPoolVisitor)classSubHierarchyInitializer);
        libraryClassPool.accept((ClassPoolVisitor)classSubHierarchyInitializer);
        if (this.configuration.keepKotlinMetadata) {
            resourceFilePool.resourceFilesAccept((ResourceFileVisitor)new KotlinModuleReferenceInitializer(programClassPool, libraryClassPool));
            if (this.configuration.enableKotlinAsserter) {
                new KotlinMetadataAsserter().execute(programClassPool, libraryClassPool, resourceFilePool, (WarningPrinter)kotlinInitializationWarningPrinter);
            }
        }
        programClassPool.classesAccept((ClassVisitor)new StringSharer());
        libraryClassPool.classesAccept((ClassVisitor)new StringSharer());
        WarningLogger classMemberNotePrinter = new WarningLogger(logger, this.configuration.note);
        if (this.checkConfiguration) {
            ClassMemberChecker classMemberChecker = new ClassMemberChecker(programClassPool, (WarningPrinter)classMemberNotePrinter);
            classMemberChecker.checkClassSpecifications(this.configuration.keep);
            classMemberChecker.checkClassSpecifications(this.configuration.assumeNoSideEffects);
            classMemberChecker.checkClassSpecifications(this.configuration.assumeNoExternalSideEffects);
            classMemberChecker.checkClassSpecifications(this.configuration.assumeNoEscapingParameters);
            classMemberChecker.checkClassSpecifications(this.configuration.assumeNoExternalReturnValues);
        }
        WarningLogger descriptorKeepNotePrinter = new WarningLogger(logger, this.configuration.note);
        if (this.checkConfiguration) {
            new DescriptorKeepChecker(programClassPool, libraryClassPool, (WarningPrinter)descriptorKeepNotePrinter).checkClassSpecifications(this.configuration.keep);
        }
        WarningLogger libraryKeepNotePrinter = new WarningLogger(logger, this.configuration.note);
        if (this.checkConfiguration) {
            new LibraryKeepChecker(programClassPool, libraryClassPool, (WarningPrinter)libraryKeepNotePrinter).checkClassSpecifications(this.configuration.keep);
        }
        resourceFilePool.resourceFilesAccept((ResourceFileVisitor)new ResourceJavaReferenceClassInitializer(programClassPool));
        int fullyQualifiedNoteCount = fullyQualifiedClassNameNotePrinter.getWarningCount();
        if (fullyQualifiedNoteCount > 0) {
            logger.info("Note: there were {} references to unknown classes.", (Object)fullyQualifiedNoteCount);
            logger.info("      You should check your configuration for typos.");
            logger.info("      (https://www.guardsquare.com/proguard/manual/troubleshooting#unknownclass)");
        }
        if ((classMemberNoteCount = classMemberNotePrinter.getWarningCount()) > 0) {
            logger.info("Note: there were {} references to unknown class members.", (Object)classMemberNoteCount);
            logger.info("      You should check your configuration for typos.");
        }
        if ((getAnnotationNoteCount = getAnnotationNotePrinter.getWarningCount()) > 0) {
            logger.info("Note: there were {} classes trying to access annotations using reflection.", (Object)getAnnotationNoteCount);
            logger.info("      You should consider keeping the annotation attributes");
            logger.info("      (using '-keepattributes *Annotation*').");
            logger.info("      (https://www.guardsquare.com/proguard/manual/troubleshooting#attributes)");
        }
        if ((getSignatureNoteCount = getSignatureNotePrinter.getWarningCount()) > 0) {
            logger.info("Note: there were {} classes trying to access generic signatures using reflection.", (Object)getSignatureNoteCount);
            logger.info("      You should consider keeping the signature attributes");
            logger.info("      (using '-keepattributes Signature').");
            logger.info("      (https://www.guardsquare.com/proguard/manual/troubleshooting#attributes)");
        }
        if ((getEnclosingClassNoteCount = getEnclosingClassNotePrinter.getWarningCount()) > 0) {
            logger.info("Note: there were {} classes trying to access enclosing classes using reflection.", (Object)getEnclosingClassNoteCount);
            logger.info("      You should consider keeping the inner classes attributes");
            logger.info("      (using '-keepattributes InnerClasses').");
            logger.info("      (https://www.guardsquare.com/proguard/manual/troubleshooting#attributes)");
        }
        if ((getEnclosingMethodNoteCount = getEnclosingMethodNotePrinter.getWarningCount()) > 0) {
            logger.info("Note: there were {} classes trying to access enclosing methods using reflection.", (Object)getEnclosingMethodNoteCount);
            logger.info("      You should consider keeping the enclosing method attributes");
            logger.info("      (using '-keepattributes InnerClasses,EnclosingMethod').");
            logger.info("      (https://www.guardsquare.com/proguard/manual/troubleshooting#attributes)");
        }
        if ((descriptorNoteCount = descriptorKeepNotePrinter.getWarningCount()) > 0) {
            logger.info("Note: there were {} unkept descriptor classes in kept class members.", (Object)descriptorNoteCount);
            logger.info("      You should consider explicitly keeping the mentioned classes");
            logger.info("      (using '-keep').");
            logger.info("      (https://www.guardsquare.com/proguard/manual/troubleshooting#descriptorclass)");
        }
        if ((libraryNoteCount = libraryKeepNotePrinter.getWarningCount()) > 0) {
            logger.info("Note: there were {} library classes explicitly being kept.", (Object)libraryNoteCount);
            logger.info("      You don't need to keep library classes; they are already left unchanged.");
            logger.info("      (https://www.guardsquare.com/proguard/manual/troubleshooting#libraryclass)");
        }
        if ((dynamicClassReferenceNoteCount = dynamicClassReferenceNotePrinter.getWarningCount()) > 0) {
            logger.info("Note: there were {} unresolved dynamic references to classes or interfaces.", (Object)dynamicClassReferenceNoteCount);
            logger.info("      You should check if you need to specify additional program jars.");
            logger.info("      (https://www.guardsquare.com/proguard/manual/troubleshooting#dynamicalclass)");
        }
        if ((classForNameNoteCount = classForNameNotePrinter.getWarningCount()) > 0) {
            logger.info("Note: there were {} class casts of dynamically created class instances.", (Object)classForNameNoteCount);
            logger.info("      You might consider explicitly keeping the mentioned classes and/or");
            logger.info("      their implementations (using '-keep').");
            logger.info("      (https://www.guardsquare.com/proguard/manual/troubleshooting#dynamicalclasscast)");
        }
        if ((getmemberNoteCount = getMemberNotePrinter.getWarningCount()) > 0) {
            logger.info("Note: there were {} accesses to class members by means of reflection.", (Object)getmemberNoteCount);
            logger.info("      You should consider explicitly keeping the mentioned class members");
            logger.info("      (using '-keep' or '-keepclassmembers').");
            logger.info("      (https://www.guardsquare.com/proguard/manual/troubleshooting#dynamicalclassmember)");
        }
        if ((classReferenceWarningCount = classReferenceWarningPrinter.getWarningCount()) > 0) {
            logger.warn("Warning: there were {} unresolved references to classes or interfaces.", (Object)classReferenceWarningCount);
            logger.warn("         You may need to add missing library jars or update their versions.");
            logger.warn("         If your code works fine without the missing classes, you can suppress");
            logger.warn("         the warnings with '-dontwarn' options.");
            if (this.configuration.skipNonPublicLibraryClasses) {
                logger.warn("         You may also have to remove the option '-skipnonpubliclibraryclasses'.");
            }
            logger.warn("         (https://www.guardsquare.com/proguard/manual/troubleshooting#unresolvedclass)");
        }
        if ((dependencyWarningCount = dependencyWarningPrinter.getWarningCount()) > 0) {
            logger.warn("Warning: there were {} instances of library classes depending on program classes.", (Object)dependencyWarningCount);
            logger.warn("         You must avoid such dependencies, since the program classes will");
            logger.warn("         be processed, while the library classes will remain unchanged.");
            logger.warn("         (https://www.guardsquare.com/proguard/manual/troubleshooting#dependency)");
        }
        if ((programMemberReferenceWarningCount = programMemberReferenceWarningPrinter.getWarningCount()) > 0) {
            logger.warn("Warning: there were {} unresolved references to program class members.", (Object)programMemberReferenceWarningCount);
            logger.warn("         Your input classes appear to be inconsistent.");
            logger.warn("         You may need to recompile the code.");
            logger.warn("         (https://www.guardsquare.com/proguard/manual/troubleshooting#unresolvedprogramclassmember)");
        }
        if ((libraryMemberReferenceWarningCount = libraryMemberReferenceWarningPrinter.getWarningCount()) > 0) {
            logger.warn("Warning: there were {} unresolved references to library class members.", (Object)libraryMemberReferenceWarningCount);
            logger.warn("         You probably need to update the library versions.");
            if (!this.configuration.skipNonPublicLibraryClassMembers) {
                logger.warn("         Alternatively, you may have to specify the option ");
                logger.warn("         '-dontskipnonpubliclibraryclassmembers'.");
            }
            if (this.configuration.skipNonPublicLibraryClasses) {
                logger.warn("         You may also have to remove the option '-skipnonpubliclibraryclasses'.");
            }
            logger.warn("         (https://www.guardsquare.com/proguard/manual/troubleshooting#unresolvedlibraryclassmember)");
        }
        if (this.configuration.keepKotlinMetadata && (kotlinInitializationWarningCount = kotlinInitializationWarningPrinter.getWarningCount()) > 0) {
            logger.warn("Warning: there were {} errors during Kotlin metadata initialisation.", (Object)kotlinInitializationWarningCount);
        }
        boolean bl = incompatibleOptimization = this.configuration.optimize && !this.configuration.shrink;
        if (incompatibleOptimization) {
            logger.warn("Warning: optimization is enabled while shrinking is disabled.");
            logger.warn("         You need to remove the option -dontshrink or optimization might result in classes that fail verification at runtime.");
        }
        if (!(classReferenceWarningCount <= 0 && dependencyWarningCount <= 0 && programMemberReferenceWarningCount <= 0 && libraryMemberReferenceWarningCount <= 0 || this.configuration.ignoreWarnings)) {
            throw new IOException("Please correct the above warnings first.");
        }
        if ((this.configuration.note == null || !this.configuration.note.isEmpty()) && (this.configuration.warn != null && this.configuration.warn.isEmpty() || this.configuration.ignoreWarnings)) {
            logger.info("Note: you're ignoring all warnings!");
        }
        logger.info("Ignoring unused library classes...");
        logger.info("  Original number of library classes: {}", (Object)originalLibraryClassPoolSize);
        logger.info("  Final number of library classes:    {}", (Object)libraryClassPool.size());
    }

    private StringMatcher createClassNoteExceptionMatcher(List noteExceptions, boolean markClasses) {
        if (noteExceptions != null) {
            ArrayList<String> noteExceptionNames = new ArrayList<String>(noteExceptions.size());
            for (int index = 0; index < noteExceptions.size(); ++index) {
                String extendsClassName;
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)noteExceptions.get(index);
                if (!keepClassSpecification.markClasses && markClasses) continue;
                String className = keepClassSpecification.className;
                if (className != null && !Initializer.containsWildCardReferences(className)) {
                    noteExceptionNames.add(className);
                }
                if ((extendsClassName = keepClassSpecification.extendsClassName) == null || Initializer.containsWildCardReferences(extendsClassName)) continue;
                noteExceptionNames.add(extendsClassName);
            }
            if (noteExceptionNames.size() > 0) {
                return new ListParser((StringParser)new ClassNameParser()).parse(noteExceptionNames);
            }
        }
        return null;
    }

    private StringMatcher createClassMemberNoteExceptionMatcher(List noteExceptions, boolean isField) {
        if (noteExceptions != null) {
            ArrayList<String> noteExceptionNames = new ArrayList<String>();
            for (int index = 0; index < noteExceptions.size(); ++index) {
                List memberSpecifications;
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)noteExceptions.get(index);
                List list = memberSpecifications = isField ? keepClassSpecification.fieldSpecifications : keepClassSpecification.methodSpecifications;
                if (memberSpecifications == null) continue;
                for (int index2 = 0; index2 < memberSpecifications.size(); ++index2) {
                    MemberSpecification memberSpecification = (MemberSpecification)memberSpecifications.get(index2);
                    String memberName = memberSpecification.name;
                    if (memberName == null || Initializer.containsWildCardReferences(memberName)) continue;
                    noteExceptionNames.add(memberName);
                }
            }
            if (noteExceptionNames.size() > 0) {
                return new ListParser((StringParser)new NameParser()).parse(noteExceptionNames);
            }
        }
        return null;
    }

    private static boolean containsWildCardReferences(String string) {
        int openIndex = string.indexOf(60);
        if (openIndex < 0) {
            return false;
        }
        int closeIndex = string.indexOf(62, openIndex + 1);
        if (closeIndex < 0) {
            return false;
        }
        try {
            Integer.parseInt(string.substring(openIndex + 1, closeIndex));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

