/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.okhttp3;

import com.growingio.android.okhttp3.OkHttpDataFetcher;
import com.growingio.android.okhttp3.SecurityExceptionInterceptor;
import com.growingio.android.sdk.track.http.EventResponse;
import com.growingio.android.sdk.track.http.EventUrl;
import com.growingio.android.sdk.track.modelloader.DataFetcher;
import com.growingio.android.sdk.track.modelloader.ModelLoader;
import com.growingio.android.sdk.track.modelloader.ModelLoaderFactory;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpDataLoader
implements ModelLoader<EventUrl, EventResponse> {
    private final Call.Factory client;

    public OkHttpDataLoader(Call.Factory client) {
        this.client = client;
    }

    public ModelLoader.LoadData<EventResponse> buildLoadData(EventUrl eventUrl) {
        return new ModelLoader.LoadData((DataFetcher)new OkHttpDataFetcher(this.client, eventUrl));
    }

    public static class Factory
    implements ModelLoaderFactory<EventUrl, EventResponse> {
        private static volatile Call.Factory sInternalClient;
        private final Call.Factory client;
        private static final int DEFAULT_CONNECT_TIMEOUT = 5;
        private static final int DEFAULT_READ_TIMEOUT = 10;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Call.Factory getsInternalClient() {
            if (sInternalClient != null) return sInternalClient;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (sInternalClient != null) return sInternalClient;
                sInternalClient = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)new SecurityExceptionInterceptor()).build();
                // ** MonitorExit[var0] (shouldn't be in output)
                return sInternalClient;
            }
        }

        public Factory() {
            this(Factory.getsInternalClient());
        }

        public Factory(Call.Factory client) {
            this.client = client;
        }

        public ModelLoader<EventUrl, EventResponse> build() {
            return new OkHttpDataLoader(this.client);
        }
    }
}

