/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.json;

import android.os.Build;
import com.growingio.android.sdk.track.events.base.BaseEvent;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.middleware.GEvent;
import com.growingio.android.sdk.track.middleware.format.EventByteArray;
import com.growingio.android.sdk.track.middleware.format.EventFormatData;
import com.growingio.android.sdk.track.middleware.format.FormatDataFetcher;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.json.JSONObject;

public class JsonDataFetcher
implements FormatDataFetcher<EventByteArray> {
    private static final String TAG = "JsonDataFetcher";
    private final EventFormatData eventData;

    public JsonDataFetcher(EventFormatData eventData) {
        this.eventData = eventData;
    }

    public EventByteArray executeData() {
        try {
            if (this.eventData.getEventOp() == 0) {
                this.assertCondition(this.eventData.getEvent() != null, "leak necessary event");
                return this.format(this.eventData.getEvent());
            }
            if (this.eventData.getEventOp() == 1) {
                this.assertCondition(this.eventData.getEvents() != null, "leak necessary events");
                return this.merge((List<byte[]>)this.eventData.getEvents());
            }
            return new EventByteArray(null);
        }
        catch (IllegalArgumentException e) {
            Logger.e((String)TAG, (Throwable)e);
            return new EventByteArray(null);
        }
    }

    public EventByteArray format(GEvent gEvent) {
        if (gEvent instanceof BaseEvent) {
            JSONObject eventJson = ((BaseEvent)gEvent).toJSONObject();
            return new EventByteArray(eventJson.toString().getBytes(), "application/json");
        }
        return new EventByteArray(null);
    }

    public EventByteArray merge(List<byte[]> events) {
        String data = this.marshall(events);
        if (Build.VERSION.SDK_INT >= 19) {
            return new EventByteArray(data.getBytes(StandardCharsets.UTF_8), "application/json");
        }
        return new EventByteArray(data.getBytes(), "application/json");
    }

    private String marshall(List<byte[]> events) {
        if (events == null || events.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        int length = events.size();
        Logger.d((String)TAG, (String)("----- merge json data size:" + length + " ----"), (Object[])new Object[0]);
        for (byte[] data : events) {
            --length;
            if (data.length > 0) {
                String event = new String(data);
                if (!event.startsWith("{") || !event.endsWith("}")) continue;
                sb.append(event);
                if (length <= 0) continue;
                sb.append(",");
                continue;
            }
            Logger.e((String)TAG, (String)"Events in the database are not in the JSON format", (Object[])new Object[0]);
        }
        sb.append("]");
        return sb.toString();
    }

    private void assertCondition(boolean condition, String msg) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    public Class<EventByteArray> getDataClass() {
        return EventByteArray.class;
    }
}

