/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.debugger;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import com.growingio.android.debugger.R;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.providers.AppInfoProvider;
import com.growingio.android.sdk.track.utils.ThreadUtils;
import com.growingio.android.sdk.track.webservices.widget.TipView;

public class ThreadSafeTipView {
    private static final String TAG = "ThreadSafeTipView";
    private TipView tipView;
    private final Context context;

    private void initView() {
        if (this.tipView == null) {
            this.tipView = new TipView(this.context);
            this.tipView.setContent(R.string.growing_debugger_connecting_to_web);
        }
    }

    public ThreadSafeTipView(Context context) {
        this.context = context;
        this.runOnUiThread(this::initView);
    }

    public void enableShow() {
        this.runOnUiThread(() -> {
            this.initView();
            this.tipView.show();
        });
    }

    public void dismiss() {
        this.runOnUiThread(() -> {
            if (this.tipView != null) {
                this.tipView.dismiss();
                this.tipView = null;
            }
        });
    }

    public void removeOnly() {
        this.runOnUiThread(() -> {
            if (this.tipView != null) {
                this.tipView.remove();
            }
        });
    }

    public void onReady(OnExitListener listener) {
        this.runOnUiThread(() -> {
            this.initView();
            this.tipView.setContent(R.string.growing_debugger_progress);
            this.tipView.setOnClickListener(v -> this.showExitDialog(listener));
        });
    }

    public void setErrorMessage(int resid) {
        this.runOnUiThread(() -> this.tipView.setErrorMessage(this.context.getResources().getText(resid)));
    }

    public void show(Activity activity) {
        this.runOnUiThread(() -> {
            this.initView();
            this.tipView.show(activity);
        });
    }

    private void showExitDialog(final OnExitListener listener) {
        Activity activity = ActivityStateProvider.get().getForegroundActivity();
        if (activity == null) {
            Logger.e((String)TAG, (String)"showExitDialog: ForegroundActivity is NULL", (Object[])new Object[0]);
            return;
        }
        String message = activity.getString(R.string.growing_debugger_app_version) + AppInfoProvider.get().getAppVersion() + activity.getString(R.string.growing_debugger_sdk_version) + "3.3.6";
        new AlertDialog.Builder((Context)activity).setTitle(R.string.growing_debugger_progress).setMessage((CharSequence)message).setPositiveButton(R.string.growing_debugger_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                listener.onExitDebugger();
            }
        }).setNegativeButton(R.string.growing_debugger_continue, null).create().show();
    }

    public void showQuitedDialog(final OnExitListener listener) {
        Activity activity = ActivityStateProvider.get().getForegroundActivity();
        if (activity == null) {
            Logger.e((String)TAG, (String)"showQuitedDialog: ForegroundActivity is NULL", (Object[])new Object[0]);
            return;
        }
        new AlertDialog.Builder((Context)activity).setTitle(R.string.growing_debugger_device_unconnected).setMessage(R.string.growing_debugger_unconnected).setPositiveButton(R.string.growing_debugger_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                listener.onExitDebugger();
            }
        }).setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                listener.onExitDebugger();
            }
        }).setCancelable(false).create().show();
    }

    private void runOnUiThread(Runnable r) {
        ThreadUtils.runOnUiThread((Runnable)r);
    }

    public static interface OnExitListener {
        public void onExitDebugger();
    }
}

