/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.debugger;

import android.content.Context;
import android.util.DisplayMetrics;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.async.Callback;
import com.growingio.android.sdk.track.async.Disposable;
import com.growingio.android.sdk.track.async.UnsubscribedDisposable;
import com.growingio.android.sdk.track.utils.DeviceUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class DebuggerScreenshot {
    private static final String MSG_TYPE = "refreshScreenshot";
    private final int mScreenWidth;
    private final int mScreenHeight;
    private final float mScale;
    private final String mScreenshot;
    private final String mMsgType;
    private final long mSnapshotKey;

    public DebuggerScreenshot(Builder builder) {
        this.mMsgType = MSG_TYPE;
        this.mScreenWidth = builder.mScreenWidth;
        this.mScreenHeight = builder.mScreenHeight;
        this.mScale = builder.mScale;
        this.mScreenshot = builder.mScreenshot;
        this.mSnapshotKey = builder.mSnapshotKey;
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put("screenWidth", this.mScreenWidth);
            json.put("screenHeight", this.mScreenHeight);
            json.put("scale", (double)this.mScale);
            json.put("screenshot", (Object)this.mScreenshot);
            json.put("msgType", (Object)this.mMsgType);
            json.put("snapshotKey", this.mSnapshotKey);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    public static final class Builder {
        private int mScreenWidth;
        private int mScreenHeight;
        private float mScale;
        private String mScreenshot;
        private long mSnapshotKey;
        private Callback<DebuggerScreenshot> mScreenshotResultCallback;
        private Disposable mBuildDisposable;

        public Builder setScale(float scale) {
            this.mScale = scale;
            return this;
        }

        public Builder setScreenshot(String screenshot) {
            this.mScreenshot = screenshot;
            return this;
        }

        public Builder setSnapshotKey(long snapshotKey) {
            this.mSnapshotKey = snapshotKey;
            return this;
        }

        public Disposable build(Callback<DebuggerScreenshot> callback) {
            if (callback == null) {
                return Disposable.EMPTY_DISPOSABLE;
            }
            this.mBuildDisposable = new UnsubscribedDisposable();
            this.mScreenshotResultCallback = callback;
            DisplayMetrics displayMetrics = DeviceUtil.getDisplayMetrics((Context)TrackerContext.get().getApplicationContext());
            this.mScreenWidth = displayMetrics.widthPixels;
            this.mScreenHeight = displayMetrics.heightPixels;
            this.callResultOnSuccess();
            return this.mBuildDisposable;
        }

        private void callResultOnSuccess() {
            if (!this.mBuildDisposable.isDisposed()) {
                this.mBuildDisposable.dispose();
                if (this.mScreenshotResultCallback != null) {
                    this.mScreenshotResultCallback.onSuccess((Object)new DebuggerScreenshot(this));
                }
            }
        }

        private void callResultOnFailed() {
            if (!this.mBuildDisposable.isDisposed()) {
                this.mBuildDisposable.dispose();
                if (this.mScreenshotResultCallback != null) {
                    this.mScreenshotResultCallback.onFailed();
                }
            }
        }
    }
}

