/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.debugger;

import com.growingio.android.debugger.DebuggerScreenshot;
import com.growingio.android.debugger.ScreenshotProvider;
import com.growingio.android.sdk.track.TrackMainThread;
import com.growingio.android.sdk.track.events.EventBuildInterceptor;
import com.growingio.android.sdk.track.events.base.BaseEvent;
import com.growingio.android.sdk.track.log.CircularFifoQueue;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.middleware.GEvent;
import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import com.growingio.android.sdk.track.webservices.log.WsLogger;
import java.util.Queue;
import org.json.JSONException;
import org.json.JSONObject;

public class DebuggerEventWrapper
implements EventBuildInterceptor,
ScreenshotProvider.OnScreenshotRefreshedListener {
    private static final String TAG = "DebuggerEventWrapper";
    public static final String SERVICE_LOGGER_OPEN = "logger_open";
    public static final String SERVICE_LOGGER_CLOSE = "logger_close";
    public static final String SERVICE_DEBUGGER_TYPE = "debugger_data";
    private OnDebuggerEventListener mOnDebuggerEventListener;
    private volatile boolean mIsConnected = false;
    private final Queue<String> mCollectionMessage = new CircularFifoQueue(50);
    private WsLogger mWsLogger;

    public static DebuggerEventWrapper get() {
        return SingleInstance.INSTANCE;
    }

    public void registerDebuggerEventListener(OnDebuggerEventListener listener) {
        this.mOnDebuggerEventListener = listener;
    }

    private DebuggerEventWrapper() {
    }

    public void observeEventBuild() {
        TrackMainThread.trackMain().addEventBuildInterceptor((EventBuildInterceptor)this);
    }

    public void ready() {
        this.mIsConnected = true;
        this.observeEventBuild();
        ScreenshotProvider.get().registerScreenshotRefreshedListener(this);
        this.sendCacheMessage();
    }

    public void end() {
        this.mIsConnected = false;
        ScreenshotProvider.get().unregisterScreenshotRefreshedListener(this);
        TrackMainThread.trackMain().removeEventBuildInterceptor((EventBuildInterceptor)this);
        this.closeLogger();
        this.mOnDebuggerEventListener = null;
    }

    private void sendCacheMessage() {
        for (String message : this.mCollectionMessage) {
            if (this.mOnDebuggerEventListener == null) continue;
            this.mOnDebuggerEventListener.onDebuggerMessage(message);
        }
        this.mCollectionMessage.clear();
    }

    public void eventWillBuild(BaseEvent.BaseBuilder<?> eventBuilder) {
    }

    public void eventDidBuild(GEvent event) {
        if (event instanceof BaseEvent) {
            BaseEvent baseEvent = (BaseEvent)event;
            try {
                JSONObject eventJson = baseEvent.toJSONObject();
                eventJson.put("url", (Object)this.getUrl());
                JSONObject json = new JSONObject();
                json.put("msgType", (Object)SERVICE_DEBUGGER_TYPE);
                json.put("sdkVersion", (Object)"3.3.6");
                json.put("data", (Object)eventJson);
                if (this.mIsConnected && this.mOnDebuggerEventListener != null) {
                    this.mOnDebuggerEventListener.onDebuggerMessage(json.toString());
                } else {
                    this.mCollectionMessage.add(json.toString());
                }
            }
            catch (JSONException ignored) {
                Logger.e((String)TAG, (String)("can't get event json " + event.getEventType()), (Object[])new Object[0]);
            }
        }
    }

    private String getUrl() {
        StringBuilder url = new StringBuilder(ConfigurationProvider.core().getDataCollectionServerHost());
        if (url.length() > 0 && url.charAt(url.length() - 1) != '/') {
            url.append("/");
        }
        url.append("v3/projects/");
        String projectId = ConfigurationProvider.core().getProjectId();
        url.append(projectId);
        url.append("/collect?stm=");
        url.append(System.currentTimeMillis());
        return url.toString();
    }

    public void printLog() {
        if (this.mWsLogger != null) {
            this.mWsLogger.printOut();
        }
    }

    public void openLogger() {
        if (this.mWsLogger == null) {
            this.mWsLogger = new WsLogger();
            this.mWsLogger.openLog();
        }
        this.mWsLogger.setCallback(logMessage -> {
            if (this.mOnDebuggerEventListener != null) {
                this.mOnDebuggerEventListener.onDebuggerMessage(logMessage);
            }
        });
    }

    public void closeLogger() {
        if (this.mWsLogger == null) {
            return;
        }
        this.mWsLogger.closeLog();
        this.mWsLogger.setCallback(null);
        this.mWsLogger = null;
    }

    @Override
    public void onScreenshotRefreshed(DebuggerScreenshot screenshot) {
        if (this.mOnDebuggerEventListener != null) {
            this.mOnDebuggerEventListener.onDebuggerMessage(screenshot.toJSONObject().toString());
        }
        this.printLog();
    }

    public static interface OnDebuggerEventListener {
        public void onDebuggerMessage(String var1);
    }

    private static class SingleInstance {
        private static final DebuggerEventWrapper INSTANCE = new DebuggerEventWrapper();

        private SingleInstance() {
        }
    }
}

