/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.database;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.util.Log;
import com.growingio.android.database.EventDataSQLiteOpenHelper;

public class EventDataContentProvider
extends ContentProvider {
    public static final String CONTENT_PROVIDER_NAME = "EventDataContentProvider";
    private static final UriMatcher MATCHER = new UriMatcher(-1);
    private static final String TAG = "EventContentProvider";
    private static final int EVENT_DATA_CODE = 1;
    private final Object mLock = new Object();
    public EventDataSQLiteOpenHelper dbHelper;

    public boolean onCreate() {
        String eventsInfoAuthority = this.getContext().getPackageName() + "." + CONTENT_PROVIDER_NAME;
        MATCHER.addURI(eventsInfoAuthority, "events", 1);
        this.dbHelper = new EventDataSQLiteOpenHelper(this.getContext());
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                SQLiteDatabase db = this.dbHelper.getReadableDatabase();
                if (MATCHER.match(uri) == 1) {
                    if ("rawQuery".equals(sortOrder)) {
                        return db.rawQuery(selection, null);
                    }
                    return db.query("events", projection, selection, selectionArgs, null, null, sortOrder);
                }
                throw new IllegalArgumentException("UnKnow Uri: " + uri.toString());
            }
        }
        catch (SQLException e) {
            Log.e((String)TAG, (String)("query error: " + e.getMessage()));
            return null;
        }
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (MATCHER.match(uri) == 1) {
            long rowId = db.insert("events", null, values);
            Uri insertUri = ContentUris.withAppendedId((Uri)uri, (long)rowId);
            this.getContext().getContentResolver().notifyChange(uri, null);
            return insertUri;
        }
        throw new IllegalArgumentException("UnKnow Uri:" + uri.toString());
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (MATCHER.match(uri) == 1) {
            int count = db.delete("events", selection, selectionArgs);
            return count;
        }
        throw new IllegalArgumentException("UnKnow Uri:" + uri.toString());
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (MATCHER.match(uri) == 1) {
            int count = db.update("events", values, selection, selectionArgs);
            return count;
        }
        throw new IllegalArgumentException("UnKnow Uri:" + uri.toString());
    }
}

