/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.database;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteFullException;
import android.util.Log;
import com.growingio.android.database.EventDataManager;
import com.growingio.android.database.EventDataSQLiteOpenHelper;
import com.growingio.android.database.EventDataTable;
import com.growingio.android.sdk.track.events.base.BaseEvent;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.middleware.GEvent;
import com.growingio.android.sdk.track.middleware.Serializer;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

@Deprecated
public class DeprecatedEventSQLite {
    private static final String TAG = "DeprecatedEventSQLite";
    private static final String DATABASE_NAME = "growing3.db";
    private final Context context;
    private boolean ignoreOperations = false;
    private final Object lock = new Object();
    public EventDataSQLiteOpenHelper dbHelper;
    private final EventDataManager dataManager;

    DeprecatedEventSQLite(Context context, EventDataManager dataManager) {
        this.dataManager = dataManager;
        this.context = context;
        File dbFile = context.getDatabasePath(DATABASE_NAME);
        if (!dbFile.exists()) {
            this.ignoreOperations = true;
        }
    }

    public void migrateEvents() {
        long runningTime = System.currentTimeMillis();
        while (this.migrateEvent() && System.currentTimeMillis() - runningTime <= 20000L) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insert(GEvent gEvent) {
        if (this.dbHelper == null) {
            this.dbHelper = new EventDataSQLiteOpenHelper(this.context, DATABASE_NAME);
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                SQLiteDatabase db = this.dbHelper.getWritableDatabase();
                db.insert("events", null, EventDataTable.putValues(Serializer.objectSerialize((Serializable)gEvent), gEvent.getEventType(), gEvent.getSendPolicy()));
            }
        }
        catch (SQLiteFullException e) {
            this.onDiskFull(e);
        }
        catch (Throwable t) {
            Logger.e((String)TAG, (Throwable)t, (String)t.getMessage(), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"Recycle"})
    private boolean migrateEvent() {
        if (this.ignoreOperations) {
            return false;
        }
        if (this.dbHelper == null) {
            this.dbHelper = new EventDataSQLiteOpenHelper(this.context, DATABASE_NAME);
        }
        String querySql = "SELECT * FROM events ORDER BY _id DESC LIMIT 100;";
        try {
            Object object = this.lock;
            synchronized (object) {
                ArrayList<GEvent> events = new ArrayList<GEvent>();
                SQLiteDatabase db = this.dbHelper.getWritableDatabase();
                try (Cursor cursor = db.rawQuery(querySql, null);){
                    long lastId = 0L;
                    while (cursor.moveToNext()) {
                        byte[] data;
                        GEvent event;
                        if (cursor.isLast()) {
                            lastId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                        }
                        if ((event = Serializer.unpack((byte[])(data = cursor.getBlob(cursor.getColumnIndexOrThrow("_data"))))) == null) continue;
                        events.add(event);
                        if (!(event instanceof BaseEvent)) continue;
                        Logger.printJson((String)TAG, (String)"------migrate data------", (String)((BaseEvent)event).toJSONObject().toString());
                    }
                    this.dataManager.insertEvents(events);
                    if (events.size() < 100) {
                        File dbFile = this.context.getDatabasePath(DATABASE_NAME);
                        if (dbFile.exists()) {
                            boolean result = dbFile.delete();
                            boolean bl = !result;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (lastId > 0L) {
                        db.delete("events", "_id>=?", new String[]{String.valueOf(lastId)});
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (SQLiteFullException e) {
                    this.onDiskFull(e);
                }
                catch (Throwable t) {
                    Logger.e((String)TAG, (Throwable)t, (String)t.getMessage(), (Object[])new Object[0]);
                }
                return false;
            }
        }
        catch (SQLException e) {
            Log.e((String)TAG, (String)("query error: " + e.getMessage()));
        }
        return false;
    }

    private void onDiskFull(SQLiteFullException e) {
        Logger.e((String)TAG, (Throwable)e, (String)"Disk full, all operations will be ignored", (Object[])new Object[0]);
        this.ignoreOperations = true;
    }
}

