/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.database;

import android.text.TextUtils;
import com.growingio.android.database.EventDataManager;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.middleware.EventDatabase;
import com.growingio.android.sdk.track.middleware.EventDbResult;
import com.growingio.android.sdk.track.modelloader.DataFetcher;

public class DatabaseDataFetcher
implements DataFetcher<EventDbResult> {
    private final EventDatabase eventDatabase;
    private final EventDataManager dataManager;

    public DatabaseDataFetcher(EventDataManager dataManager, EventDatabase eventDatabase) {
        this.eventDatabase = eventDatabase;
        this.dataManager = dataManager;
    }

    public EventDbResult executeData() {
        try {
            return this.executeDatabase(this.eventDatabase);
        }
        catch (IllegalArgumentException e) {
            EventDbResult dbResult = new EventDbResult(false);
            Logger.e((String)"DatabaseDataFetcher", (Throwable)e);
            return dbResult;
        }
    }

    private EventDbResult executeDatabase(EventDatabase database) throws IllegalArgumentException {
        EventDbResult dbResult = new EventDbResult();
        if (database.getDbOp() == 0) {
            this.assertCondition(database.getEvents() != null && !database.getEvents().isEmpty(), "leak necessary event");
            int count = this.dataManager.insertEvents(database.getEvents());
            dbResult.setSum(count);
            dbResult.setSuccess(count == database.getEvents().size());
            return dbResult;
        }
        if (database.getDbOp() == 4) {
            int sum = this.dataManager.removeOverdueEvents();
            dbResult.setSum(sum);
            dbResult.setSuccess(sum >= 0);
            return dbResult;
        }
        if (database.getDbOp() == 1) {
            this.assertCondition(database.getLimit() > 0 && database.getPolicy() >= 1 && database.getPolicy() <= 3, "leak necessary param");
            this.dataManager.queryEvents(database.getPolicy(), database.getLimit(), dbResult);
            return dbResult;
        }
        if (database.getDbOp() == 3) {
            this.assertCondition(database.getLastId() > 0L && database.getPolicy() >= 1 && database.getPolicy() <= 3 && !TextUtils.isEmpty((CharSequence)database.getEventType()), "leak necessary param");
            int sum = this.dataManager.removeEvents(database.getLastId(), database.getPolicy(), database.getEventType());
            dbResult.setSum(sum);
            dbResult.setSuccess(sum >= 0);
            return dbResult;
        }
        if (database.getDbOp() == 5) {
            this.assertCondition(database.getLimit() > 0 && database.getPolicy() >= 1 && database.getPolicy() <= 3, "leak necessary param");
            this.dataManager.queryEventsAndDelete(database.getPolicy(), database.getLimit(), dbResult);
            return dbResult;
        }
        if (database.getDbOp() == 6) {
            this.dataManager.removeAllEvents();
            dbResult.setSuccess(true);
            return dbResult;
        }
        dbResult.setSuccess(false);
        return dbResult;
    }

    private void assertCondition(boolean condition, String msg) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    public Class<EventDbResult> getDataClass() {
        return EventDbResult.class;
    }
}

