/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.growingio.android.sdk.track.events.EventBuildInterceptor;
import com.growingio.android.sdk.track.events.base.BaseEvent;
import com.growingio.android.sdk.track.ipc.PersistentDataProvider;
import com.growingio.android.sdk.track.listener.OnUserIdChangedListener;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.middleware.GEvent;
import com.growingio.android.sdk.track.providers.UserInfoProvider;

public class CdpEventBuildInterceptor
implements EventBuildInterceptor,
OnUserIdChangedListener {
    private static final String TAG = "CdpEventBuildInterceptor";
    private static final String KEY_GIO_ID = "GIO_ID";
    private final String mDataSourceId;

    public CdpEventBuildInterceptor(String dataSourceId) {
        this.mDataSourceId = dataSourceId;
        UserInfoProvider.get().registerUserIdChangedListener((OnUserIdChangedListener)this);
    }

    public void eventWillBuild(BaseEvent.BaseBuilder<?> eventBuilder) {
        eventBuilder.addExtraParam("dataSourceId", this.mDataSourceId);
        String mLatestGioId = this.getGioId();
        if (!TextUtils.isEmpty((CharSequence)mLatestGioId)) {
            eventBuilder.addExtraParam("gioId", mLatestGioId);
        }
    }

    public void eventDidBuild(GEvent event) {
    }

    private String getGioId() {
        return PersistentDataProvider.get().getString(KEY_GIO_ID, null);
    }

    private void setGioId(String gioId) {
        PersistentDataProvider.get().putString(KEY_GIO_ID, gioId);
    }

    public void onUserIdChanged(@Nullable String newUserId) {
        String mLatestGioId = this.getGioId();
        Logger.d((String)TAG, (String)("onUserIdChanged: newUserId = " + newUserId + ", mLatestGioId = " + mLatestGioId), (Object[])new Object[0]);
        if (newUserId != null && newUserId.length() != 0 && !newUserId.equals(mLatestGioId)) {
            this.setGioId(newUserId);
        }
    }
}

