/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.swap.parameters;

import com.groupcdg.arcmutate.mutators.MethodLocation;
import com.groupcdg.arcmutate.mutators.swap.parameters.SwapIndices;
import java.util.Optional;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;

class ParamSwapVisitor
extends MethodVisitor {
    private final MethodMutatorFactory factory;
    private final MutationContext context;

    ParamSwapVisitor(MutationContext context, MethodVisitor writer, MethodMutatorFactory factory) {
        super(589824, writer);
        this.factory = factory;
        this.context = context;
    }

    private static void swap(MethodVisitor mv, Type type) {
        if (type.getSize() == 1) {
            mv.visitInsn(95);
        } else {
            mv.visitInsn(94);
            mv.visitInsn(88);
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        MethodLocation location = MethodLocation.location(ClassName.fromString((String)owner), name, desc);
        Type[] params = Type.getArgumentTypes((String)desc);
        Optional<SwapIndices> maybeSwappable = ParamSwapVisitor.findSwappableParams(params);
        if (maybeSwappable.isPresent()) {
            this.createMutation(location, params, maybeSwappable.get());
        }
        this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    private void createMutation(MethodLocation location, Type[] params, SwapIndices indices) {
        MutationIdentifier newId = this.context.registerMutation(this.factory, "swapped parameters " + indices.first() + " and " + indices.second() + " in call to " + this.describe(location));
        if (this.context.shouldMutate(newId)) {
            ParamSwapVisitor.swap(this.mv, params[indices.first() - 1]);
        }
    }

    public static Optional<SwapIndices> findSwappableParams(Type[] params) {
        if (params.length > 1 && params[params.length - 2].equals((Object)params[params.length - 1])) {
            return Optional.of(new SwapIndices(params.length - 1, params.length));
        }
        return Optional.empty();
    }

    private String describe(MethodLocation location) {
        return location.methodName();
    }
}

