/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.swap.parameters;

import com.groupcdg.arcmutate.AnalysingInterceptor;
import com.groupcdg.arcmutate.mutators.SignatureTokenizer;
import com.groupcdg.arcmutate.mutators.swap.parameters.ParamSwapMutator;
import com.groupcdg.arcmutate.mutators.swap.parameters.ParamSwapVisitor;
import com.groupcdg.arcmutate.mutators.swap.parameters.SwapIndices;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.reloc.asm.Type;

class JunkParamSwapInterceptor
extends AnalysingInterceptor {
    private static final Set<String> COMMUTATIVE = new HashSet<String>(Arrays.asList("equals", "add", "addExact", "min", "max", "of", "deepEquals"));
    private final ClassByteArraySource source;

    public JunkParamSwapInterceptor(ClassByteArraySource source) {
        this.source = source;
    }

    @Override
    public Stream<MutationDetails> intercept(Collection<MutationDetails> mutants) {
        return mutants.stream().filter(this.isJunkParamSwapMutant().negate());
    }

    private Predicate<MutationDetails> isJunkParamSwapMutant() {
        return mutant -> this.isAParamSwapMutant((MutationDetails)mutant) && this.isJunk((MutationDetails)mutant);
    }

    private boolean isJunk(MutationDetails mutant) {
        Optional maybeMethod = this.currentClass.method(mutant.getId().getLocation());
        if (!maybeMethod.isPresent()) {
            return false;
        }
        MethodTree method = (MethodTree)maybeMethod.get();
        AbstractInsnNode instruction = method.instruction(mutant.getInstructionIndex());
        MethodInsnNode call = (MethodInsnNode)instruction;
        return this.nameSuggestsEquivalence(call.name) || this.isEquivalent(call, method) || this.paramsHaveMismatchedGenerics(call);
    }

    private boolean nameSuggestsEquivalence(String name) {
        return COMMUTATIVE.contains(name);
    }

    private boolean isEquivalent(MethodInsnNode call, MethodTree method) {
        int callIndex = method.instructions().indexOf(call);
        return this.match(method.instruction(callIndex - 1), method.instruction(callIndex - 2));
    }

    private boolean match(AbstractInsnNode op1, AbstractInsnNode op2) {
        if (op1.getClass() != op2.getClass()) {
            return false;
        }
        if (op1.getOpcode() != op2.getOpcode()) {
            return false;
        }
        if (op1 instanceof VarInsnNode) {
            return ((VarInsnNode)op1).var == ((VarInsnNode)op2).var;
        }
        if (op1 instanceof IntInsnNode) {
            return ((IntInsnNode)op1).operand == ((IntInsnNode)op2).operand;
        }
        if (op1 instanceof LdcInsnNode) {
            return ((LdcInsnNode)op1).cst.equals(((LdcInsnNode)op2).cst);
        }
        return true;
    }

    private boolean paramsHaveMismatchedGenerics(MethodInsnNode call) {
        SwapIndices swappable;
        Type[] params = Type.getArgumentTypes((String)call.desc);
        Type t = params[(swappable = ParamSwapVisitor.findSwappableParams(params).get()).first() - 1];
        if (t.getSort() != 10) {
            return false;
        }
        Optional maybeBytes = this.source.getBytes(call.owner);
        if (!maybeBytes.isPresent()) {
            return true;
        }
        ClassTree o = ClassTree.fromBytes((byte[])((byte[])maybeBytes.get()));
        Optional<MethodTree> called = this.findMethod(call, o);
        if (!called.isPresent() || called.get().rawNode().signature == null) {
            return false;
        }
        SignatureTokenizer tokenizer = new SignatureTokenizer();
        List<String> fullParamTypes = tokenizer.tokeniseParams(called.get().rawNode().signature);
        if (fullParamTypes.size() <= swappable.secondIndex()) {
            return true;
        }
        return !fullParamTypes.get(swappable.firstIndex()).equals(fullParamTypes.get(swappable.secondIndex()));
    }

    private Optional<MethodTree> findMethod(MethodInsnNode call, ClassTree o) {
        return o.method(Location.location((ClassName)ClassName.fromString((String)call.owner), (String)call.name, (String)call.desc));
    }

    private boolean isAParamSwapMutant(MutationDetails mutant) {
        return mutant.getId().getMutator().equals(ParamSwapMutator.SWAP_PARAMS.getGloballyUniqueId());
    }
}

