/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.swap;

import com.groupcdg.arcmutate.mutators.MethodLocation;
import java.util.Map;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.MethodVisitor;

class SwapCallVisitor
extends MethodVisitor {
    private final Map<MethodLocation, MethodLocation> targets;
    private final MethodMutatorFactory factory;
    private final MutationContext context;

    SwapCallVisitor(MutationContext context, MethodVisitor writer, Map<MethodLocation, MethodLocation> targets, MethodMutatorFactory factory) {
        super(589824, writer);
        this.targets = targets;
        this.factory = factory;
        this.context = context;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        MutationIdentifier newId;
        MethodLocation location = MethodLocation.location(ClassName.fromString((String)owner), name, desc);
        MethodLocation replacement = this.targets.get(location);
        if (replacement != null && this.context.shouldMutate(newId = this.context.registerMutation(this.factory, "swapped call to " + this.describe(location) + " for " + this.describe(replacement)))) {
            this.mv.visitMethodInsn(opcode, replacement.className().asInternalName(), replacement.methodName(), replacement.methodDesc(), itf);
            return;
        }
        this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    private String describe(MethodLocation location) {
        return location.methodName();
    }
}

