/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.overloads;

import com.groupcdg.arcmutate.mutators.MethodDesc;
import com.groupcdg.arcmutate.mutators.MethodLocation;
import com.groupcdg.arcmutate.mutators.UnifiedType;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;

class OneLessVisitor
extends MethodVisitor {
    private static final Set<MethodLocation> SWAPS = new HashSet<MethodLocation>();
    private final MethodMutatorFactory factory;
    private final MutationContext context;

    OneLessVisitor(MutationContext context, MethodVisitor writer, MethodMutatorFactory factory) {
        super(589824, writer);
        this.factory = factory;
        this.context = context;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        MethodLocation location = MethodLocation.location(ClassName.fromString((String)owner), name, desc);
        Type[] params = Type.getArgumentTypes((String)desc);
        if (SWAPS.contains(location)) {
            if (!this.createMutation(location, params, opcode, itf)) {
                this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        } else {
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private boolean createMutation(MethodLocation orig, Type[] params, int opcode, boolean itf) {
        MethodLocation replacement = orig.removeLastParam().get();
        MutationIdentifier newId = this.context.registerMutation(this.factory, this.describe(orig, replacement));
        if (this.context.shouldMutate(newId)) {
            this.popArgument(params[params.length - 1]);
            this.mv.visitMethodInsn(opcode, replacement.className().asInternalName(), replacement.methodName(), replacement.methodDesc(), itf);
            return true;
        }
        return false;
    }

    private void popArgument(Type argumentType) {
        if (argumentType.getSize() != 1) {
            this.mv.visitInsn(88);
        } else {
            this.mv.visitInsn(87);
        }
    }

    private String describe(MethodLocation orig, MethodLocation replacement) {
        return "replaced call to " + orig.describe() + " with " + replacement.describe();
    }

    static {
        for (int i = 0; i != 10; ++i) {
            SWAPS.add(MethodLocation.location(List.class, "of", MethodDesc.returning(List.class).withParams(UnifiedType.object(Object.class), i + 1)));
            SWAPS.add(MethodLocation.location(Set.class, "of", MethodDesc.returning(Set.class).withParams(UnifiedType.object(Object.class), i + 1)));
            SWAPS.add(MethodLocation.location(UnifiedType.RX3_FLOWABLE.asClass(), "just", MethodDesc.returning(UnifiedType.RX3_FLOWABLE).withParams(UnifiedType.object(Object.class), i + 1)));
            SWAPS.add(MethodLocation.location(UnifiedType.RX2_FLOWABLE.asClass(), "just", MethodDesc.returning(UnifiedType.RX2_FLOWABLE).withParams(UnifiedType.object(Object.class), i + 1)));
            SWAPS.add(MethodLocation.location(UnifiedType.RX3_OBSERVABLE.asClass(), "just", MethodDesc.returning(UnifiedType.RX3_OBSERVABLE).withParams(UnifiedType.object(Object.class), i + 1)));
            SWAPS.add(MethodLocation.location(UnifiedType.RX2_OBSERVABLE.asClass(), "just", MethodDesc.returning(UnifiedType.RX2_OBSERVABLE).withParams(UnifiedType.object(Object.class), i + 1)));
            SWAPS.add(MethodLocation.location(EnumSet.class, "of", MethodDesc.returning(EnumSet.class).withParams(UnifiedType.object(Enum.class), i + 1)));
            SWAPS.add(MethodLocation.location(LocalDateTime.class, "of", MethodDesc.returning(LocalDateTime.class).withParams(UnifiedType.INT, i + 1)));
            SWAPS.add(MethodLocation.location(LocalTime.class, "of", MethodDesc.returning(LocalTime.class).withParams(UnifiedType.INT, i + 1)));
        }
    }
}

