/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.extreme;

import com.groupcdg.arcmutate.mutators.Mutator;
import com.groupcdg.arcmutate.mutators.UnifiedType;
import com.groupcdg.arcmutate.mutators.bytecode.Replacement;
import com.groupcdg.arcmutate.mutators.extreme.RemovalVisitor;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.MethodVisitor;

public interface ExtremeMutator
extends MethodMutatorFactory {
    public Mutator mutator();

    public static boolean isExtreme(String mutator) {
        try {
            Class<?> m = Class.forName(mutator);
            return ExtremeMutator.class.isAssignableFrom(m);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    default public String getGloballyUniqueId() {
        return this.getClass().getName();
    }

    default public String getName() {
        return this.mutator().name();
    }

    default public MethodVisitor create(MutationContext context, MethodInfo methodInfo, MethodVisitor methodVisitor) {
        if (methodInfo.isConstructor() || (methodInfo.getAccess() & 0x400) != 0 || methodInfo.isSynthetic()) {
            return methodVisitor;
        }
        RemovalVisitor mutateWith = this.pickVisitor(methodInfo.getMethodDescriptor(), methodVisitor);
        if (mutateWith != null) {
            ClassName clazz = ClassName.fromString((String)context.getClassInfo().getName());
            Location loc = Location.location((ClassName)clazz, (String)methodInfo.getName(), (String)methodInfo.getMethodDescriptor());
            MutationIdentifier id = new MutationIdentifier(loc, 1, this.getGloballyUniqueId());
            context.registerMutation(id, "Removed body of " + methodInfo.getName() + mutateWith.describe());
            if (context.shouldMutate(id)) {
                return mutateWith;
            }
        }
        return methodVisitor;
    }

    default public Map<UnifiedType, Replacement> replacements() {
        return Replacement.replacementsFor(this.mutator()).stream().collect(Collectors.toMap(r -> r.type(), Function.identity()));
    }

    default public RemovalVisitor pickVisitor(String methodDesc, MethodVisitor mv) {
        UnifiedType returnType = UnifiedType.parseMethodDescriptor(methodDesc);
        return this.pickVisitor(returnType, mv);
    }

    default public RemovalVisitor pickVisitor(UnifiedType returnType, MethodVisitor mv) {
        Replacement replacement = this.replacements().get(returnType);
        if (replacement != null) {
            return new RemovalVisitor(replacement, mv, replacement.returnValue());
        }
        return null;
    }
}

