/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.extreme;

import com.groupcdg.arcmutate.mutators.extreme.ExtremeMutator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.LineNumberNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class ExtremeMutationModifier
implements MutationInterceptor {
    public static final int FIRST_BLOCK_OF_METHOD = 0;
    private ClassTree clazz;
    private final Map<String, Boolean> extremeMutators = new ConcurrentHashMap<String, Boolean>();

    public InterceptorType type() {
        return InterceptorType.MODIFY;
    }

    public void begin(ClassTree classTree) {
        this.clazz = classTree;
    }

    public Collection<MutationDetails> intercept(Collection<MutationDetails> collection, Mutater mutater) {
        return collection.stream().map(this::update).collect(Collectors.toList());
    }

    private MutationDetails update(MutationDetails md) {
        boolean isExtreme = this.extremeMutators.computeIfAbsent(md.getId().getMutator(), this::isExtreme);
        if (!isExtreme) {
            return md;
        }
        Optional maybeMethod = this.clazz.method(md.getId().getLocation());
        if (!maybeMethod.isPresent()) {
            return md;
        }
        int lastLine = ((MethodTree)maybeMethod.get()).instructions().stream().filter(n -> n instanceof LineNumberNode).mapToInt(n -> ((LineNumberNode)n).line).max().orElse(1);
        return new MutationDetails(md.getId(), md.getFilename(), md.getDescription(), lastLine, 0);
    }

    private Boolean isExtreme(String mutator) {
        try {
            Class<?> m = Class.forName(mutator);
            return ExtremeMutator.class.isAssignableFrom(m);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public void end() {
        this.clazz = null;
    }
}

