/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.bytecode;

import com.groupcdg.arcmutate.mutators.Mutator;
import com.groupcdg.arcmutate.mutators.UnifiedType;
import com.groupcdg.arcmutate.mutators.bytecode.ASMToQuery;
import com.groupcdg.arcmutate.mutators.bytecode.ASMToReturnValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.pitest.classinfo.ClassName;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.sequence.SequenceQuery;

public enum Replacement implements Consumer<MethodVisitor>
{
    OBJECT(UnifiedType.object(Object.class), Mutator.EXTREME_NULL){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(1);
            mv.visitInsn(176);
        }
    }
    ,
    VOID(UnifiedType.VOID, Mutator.EXTREME_VOID){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(177);
        }
    }
    ,
    PRIMITIVE_INT(UnifiedType.INT, Mutator.EXTREME_ZERO){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(3);
            mv.visitInsn(172);
        }
    }
    ,
    PRIMITIVE_BYTE(UnifiedType.BYTE, Mutator.EXTREME_ZERO){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(3);
            mv.visitInsn(172);
        }
    }
    ,
    PRIMITIVE_CHAR(UnifiedType.CHAR, Mutator.EXTREME_ZERO){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(3);
            mv.visitInsn(172);
        }
    }
    ,
    PRIMITIVE_SHORT(UnifiedType.SHORT, Mutator.EXTREME_ZERO){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(3);
            mv.visitInsn(172);
        }
    }
    ,
    PRIMITIVE_BOOLEAN(UnifiedType.BOOLEAN, Mutator.EXTREME_BOOLEAN){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(3);
            mv.visitInsn(172);
        }
    }
    ,
    PRIMITIVE_LONG(UnifiedType.LONG, Mutator.EXTREME_ZERO){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(9);
            mv.visitInsn(173);
        }
    }
    ,
    PRIMITIVE_FLOAT(UnifiedType.FLOAT, Mutator.EXTREME_ZERO){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(11);
            mv.visitInsn(174);
        }
    }
    ,
    PRIMITIVE_DOUBLE(UnifiedType.DOUBLE, Mutator.EXTREME_ZERO){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(14);
            mv.visitInsn(175);
        }
    }
    ,
    BOXED_BOOLEAN(UnifiedType.object(Boolean.class), "valueOf", new Mutator[]{Mutator.EXTREME_BOOLEAN}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(3);
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "(Z)Ljava/lang/Boolean;", false);
            mv.visitInsn(176);
        }
    }
    ,
    BOXED_INTEGER(UnifiedType.object(Integer.class), "valueOf", new Mutator[]{Mutator.EXTREME_ZERO}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(3);
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "(I)Ljava/lang/Integer;", false);
            mv.visitInsn(176);
        }
    }
    ,
    BOXED_BYTE(UnifiedType.object(Byte.class), "valueOf", new Mutator[]{Mutator.EXTREME_ZERO}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(3);
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "(B)Ljava/lang/Byte;", false);
            mv.visitInsn(176);
        }
    }
    ,
    BOXED_CHAR(UnifiedType.object(Character.class), "valueOf", new Mutator[]{Mutator.EXTREME_ZERO}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(3);
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "(C)Ljava/lang/Character;", false);
            mv.visitInsn(176);
        }
    }
    ,
    BOXED_SHORT(UnifiedType.object(Short.class), "valueOf", new Mutator[]{Mutator.EXTREME_ZERO}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(3);
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "(S)Ljava/lang/Short;", false);
            mv.visitInsn(176);
        }
    }
    ,
    BOXED_LONG(UnifiedType.object(Long.class), "valueOf", new Mutator[]{Mutator.EXTREME_ZERO}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(9);
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "(J)Ljava/lang/Long;", false);
            mv.visitInsn(176);
        }
    }
    ,
    BOXED_FLOAT(UnifiedType.object(Float.class), "valueOf", new Mutator[]{Mutator.EXTREME_ZERO}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(11);
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "(F)Ljava/lang/Float;", false);
            mv.visitInsn(176);
        }
    }
    ,
    BOXED_DOUBLE(UnifiedType.object(Double.class), "valueOf", new Mutator[]{Mutator.EXTREME_ZERO}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitInsn(14);
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "(D)Ljava/lang/Double;", false);
            mv.visitInsn(176);
        }
    }
    ,
    STRING(UnifiedType.object(String.class), null, new Mutator[]{Mutator.EXTREME_EMPTY}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitLdcInsn((Object)"");
            mv.visitInsn(176);
        }
    }
    ,
    RX_MAYBE(UnifiedType.RX3_MAYBE, "empty", new Mutator[]{Mutator.EXTREME_EMPTY, Mutator.REACTIVE}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "()L" + this.owner().asInternalName() + ";", false);
            mv.visitInsn(176);
        }
    }
    ,
    RX_FLOWABLE(UnifiedType.RX3_FLOWABLE, "empty", new Mutator[]{Mutator.EXTREME_EMPTY, Mutator.REACTIVE}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "()L" + this.owner().asInternalName() + ";", false);
            mv.visitInsn(176);
        }
    }
    ,
    RX_OBSERVABLE(UnifiedType.RX3_OBSERVABLE, "empty", new Mutator[]{Mutator.EXTREME_EMPTY, Mutator.REACTIVE}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "()L" + this.owner().asInternalName() + ";", false);
            mv.visitInsn(176);
        }
    }
    ,
    RX2_MAYBE(UnifiedType.RX2_MAYBE, "empty", new Mutator[]{Mutator.EXTREME_EMPTY, Mutator.REACTIVE}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "()L" + this.owner().asInternalName() + ";", false);
            mv.visitInsn(176);
        }
    }
    ,
    RX2_FLOWABLE(UnifiedType.RX2_FLOWABLE, "empty", new Mutator[]{Mutator.EXTREME_EMPTY, Mutator.REACTIVE}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "()L" + this.owner().asInternalName() + ";", false);
            mv.visitInsn(176);
        }
    }
    ,
    RX2_OBSERVABLE(UnifiedType.RX2_OBSERVABLE, "empty", new Mutator[]{Mutator.EXTREME_EMPTY, Mutator.REACTIVE}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "()L" + this.owner().asInternalName() + ";", false);
            mv.visitInsn(176);
        }
    }
    ,
    MONO(UnifiedType.MONO, "empty", new Mutator[]{Mutator.EXTREME_EMPTY, Mutator.REACTIVE}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "()L" + this.owner().asInternalName() + ";", false);
            mv.visitInsn(176);
        }
    }
    ,
    FLUX(UnifiedType.FLUX, "empty", new Mutator[]{Mutator.EXTREME_EMPTY, Mutator.REACTIVE}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "()L" + this.owner().asInternalName() + ";", false);
            mv.visitInsn(176);
        }
    }
    ,
    GUAVA_OPTIONAL(UnifiedType.GUAVA_OPTIONAL, "absent", new Mutator[]{Mutator.EXTREME_EMPTY, Mutator.REACTIVE}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "()L" + this.owner().asInternalName() + ";", false);
            mv.visitInsn(176);
        }
    }
    ,
    OPTIONAL(UnifiedType.object(Optional.class), "empty", new Mutator[]{Mutator.EXTREME_EMPTY}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "()L" + this.owner().asInternalName() + ";", false);
            mv.visitInsn(176);
        }
    }
    ,
    STREAM(UnifiedType.object(Stream.class), "empty", new Mutator[]{Mutator.EXTREME_EMPTY}){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, this.owner().asInternalName(), this.method(), "()L" + this.owner().asInternalName() + ";", true);
            mv.visitInsn(176);
        }
    }
    ,
    LIST(UnifiedType.object(List.class), Mutator.EXTREME_EMPTY){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, "java/util/Collections", "emptyList", "()Ljava/util/List;", false);
            mv.visitInsn(176);
        }
    }
    ,
    SET(UnifiedType.object(Set.class), Mutator.EXTREME_EMPTY){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, "java/util/Collections", "emptySet", "()Ljava/util/Set;", false);
            mv.visitInsn(176);
        }
    }
    ,
    MAP(UnifiedType.object(Map.class), Mutator.EXTREME_EMPTY){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, "java/util/Collections", "emptyMap", "()Ljava/util/Map;", false);
            mv.visitInsn(176);
        }
    }
    ,
    COLLECTION(UnifiedType.object(Collection.class), Mutator.EXTREME_EMPTY){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, "java/util/Collections", "emptyList", "()Ljava/util/List;", false);
            mv.visitInsn(176);
        }
    }
    ,
    ITERABLE(UnifiedType.object(Iterable.class), Mutator.EXTREME_EMPTY){

        @Override
        public void accept(MethodVisitor mv) {
            mv.visitMethodInsn(184, "java/util/Collections", "emptyList", "()Ljava/util/List;", false);
            mv.visitInsn(176);
        }
    };

    private final Set<Mutator> mutator;
    private final String method;
    private final UnifiedType owner;

    private Replacement(UnifiedType owner, Mutator mutator) {
        this(owner, null, mutator);
    }

    private Replacement(UnifiedType owner, String method, Mutator ... mutators) {
        this.owner = owner;
        this.method = method;
        this.mutator = Arrays.stream(mutators).collect(Collectors.toSet());
    }

    public static List<Replacement> replacementsFor(Mutator mutator) {
        return Arrays.stream(Replacement.values()).filter(r -> r.mutators().contains((Object)mutator)).collect(Collectors.toList());
    }

    @Override
    public abstract void accept(MethodVisitor var1);

    public String returnValue() {
        ASMToReturnValue c = new ASMToReturnValue();
        this.accept(c);
        return c.returnDescription();
    }

    public ClassName owner() {
        return this.owner.asClass();
    }

    public UnifiedType type() {
        return this.owner;
    }

    public String method() {
        return this.method;
    }

    public Set<Mutator> mutators() {
        return this.mutator;
    }

    public static SequenceQuery<AbstractInsnNode> generateFilter() {
        SequenceQuery query = null;
        for (Replacement each : Replacement.values()) {
            query = query == null ? each.match() : query.or(each.match());
        }
        return query;
    }

    public SequenceQuery<AbstractInsnNode> match() {
        ASMToQuery c = new ASMToQuery();
        this.accept(c);
        return c.query;
    }
}

