/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.bytecode;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.ASMVersion;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceQuery;

class ASMToQuery
extends MethodVisitor {
    SequenceQuery<AbstractInsnNode> query = null;

    ASMToQuery() {
        super(ASMVersion.asmVersion());
    }

    public void visitInsn(int opcode) {
        this.append((Match<AbstractInsnNode>)InstructionMatchers.opCode((int)opcode));
    }

    public void visitLdcInsn(Object value) {
        this.append(ASMToQuery.ldc(value));
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.append((Match<AbstractInsnNode>)InstructionMatchers.opCode((int)opcode).and(ASMToQuery.methodCall(owner, name, descriptor)));
    }

    private void append(Match<AbstractInsnNode> match) {
        this.query = this.query == null ? QueryStart.match(match) : this.query.then(match);
    }

    private static Match<AbstractInsnNode> ldc(Object l) {
        return (c, n) -> Result.result((n instanceof LdcInsnNode && ((LdcInsnNode)n).cst.equals(l) ? 1 : 0) != 0, (Context)c);
    }

    private static Match<AbstractInsnNode> methodCall(String owner, String name, String descriptor) {
        return (c, t) -> {
            if (t instanceof MethodInsnNode) {
                MethodInsnNode call = (MethodInsnNode)t;
                return Result.result((call.owner.equals(owner) && call.name.equals(name) && call.desc.equals(descriptor) ? 1 : 0) != 0, (Context)c);
            }
            return Result.result((boolean)false, (Context)c);
        };
    }
}

