/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators;

import com.groupcdg.arcmutate.mutators.Status;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

class ParserState {
    private final String desc;
    private Deque<Status> statusStack = new ArrayDeque<Status>();
    List<String> tokens = new ArrayList<String>();
    private int pos = 0;
    private int advance = 1;

    ParserState(String desc) {
        this.desc = desc;
        this.statusStack.push(Status.START);
    }

    void step() {
        this.statusStack.peek().parse(this);
    }

    void consumeToken() {
        String token = this.desc.substring(this.pos, this.advance);
        this.pos = this.advance;
        this.advance = this.pos + 1;
        this.tokens.add(token);
    }

    void advanceAndChangeTo(Status s) {
        this.statusStack.push(s);
        this.advance();
    }

    public void advanceAndPop() {
        this.statusStack.pop();
        this.advance();
    }

    void popState() {
        this.statusStack.pop();
    }

    void advance() {
        ++this.advance;
    }

    char current() {
        return this.desc.charAt(this.advance - 1);
    }

    public boolean incomplete() {
        return this.pos < this.desc.length();
    }
}

