/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.exclusions.plugin;

import com.groupcdg.arcmutate.exclusions.analysis.Locator;
import com.groupcdg.arcmutate.exclusions.analysis.Or;
import com.groupcdg.arcmutate.exclusions.analysis.TextExclusion;
import com.groupcdg.arcmutate.exclusions.plugin.SourceParser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class SourceScanningInterceptor
implements MutationInterceptor {
    private final Locator locator;
    private Predicate<MutationDetails> filter;

    public SourceScanningInterceptor(Locator locator) {
        this.locator = locator;
    }

    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    public void begin(ClassTree clazz) {
        Optional<Path> maybePath;
        List excludes;
        if (clazz.rawNode().sourceFile != null && !(excludes = (maybePath = this.locator.locate(Arrays.asList(clazz.name().asJavaName()), clazz.rawNode().sourceFile)).map(path -> this.analyse((Path)path).stream().map(TextExclusion::asExclusion).collect(Collectors.toList())).orElse(Collections.emptyList())).isEmpty()) {
            this.filter = Or.or(excludes).negate();
        }
    }

    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        if (this.filter == null) {
            return mutations;
        }
        return mutations.stream().filter(this.filter).collect(Collectors.toList());
    }

    public void end() {
        this.filter = null;
    }

    private List<TextExclusion> analyse(Path root) {
        List<TextExclusion> list;
        block8: {
            Stream<Path> sources = Files.find(root, 100, (p, a) -> a.isRegularFile(), new FileVisitOption[0]);
            try {
                list = sources.filter(Files::isReadable).flatMap(p -> new SourceParser().parse((Path)p).stream()).collect(Collectors.toList());
                if (sources == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (sources != null) {
                        try {
                            sources.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            sources.close();
        }
        return list;
    }
}

