/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.exclusions.plugin;

import com.groupcdg.arcmutate.exclusions.analysis.ExclusionParser;
import com.groupcdg.arcmutate.exclusions.analysis.Or;
import com.groupcdg.arcmutate.exclusions.plugin.ExclusionInterceptor;
import com.groupcdg.pitest.extended.licence.Licence;
import com.groupcdg.pitest.extended.licence.LicencePathFinder;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.plugin.Feature;
import org.pitest.util.Glob;

public class ExclusionsFactory
implements MutationInterceptorFactory {
    private final FileSystem fs;

    public ExclusionsFactory() {
        this(FileSystems.getDefault());
    }

    public ExclusionsFactory(FileSystem fs) {
        this.fs = fs;
    }

    public MutationInterceptor createInterceptor(InterceptorParameters interceptorParameters) {
        ExclusionParser parser = new ExclusionParser();
        ReportOptions data = interceptorParameters.data();
        Stream<Path> locations = Stream.concat(data.getSourcePaths().stream(), Stream.of(this.fs.getPath(data.getReportDir(), new String[0])));
        List predicates = locations.filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(Files::isReadable).map(parser::parseDirectory).collect(Collectors.toList());
        return new ExclusionInterceptor(Or.or(predicates), ExclusionsFactory.makeFilter(this.findLicence(interceptorParameters.data())));
    }

    public Feature provides() {
        return Feature.named((String)"EXCLUSION").withOnByDefault(false).withDescription(this.description());
    }

    public String description() {
        return "Filter mutations from list of exclusions";
    }

    private static Predicate<ClassName> makeFilter(Licence licence) {
        Collection globs = Glob.toGlobPredicates(licence.packages());
        return c -> globs.stream().anyMatch(g -> g.test(c.asJavaName()));
    }

    private Licence findLicence(ReportOptions data) {
        try {
            Path workingDir = this.fs.getPath("", new String[0]).toRealPath(new LinkOption[0]);
            Path reportDir = this.fs.getPath(data.getReportDir(), new String[0]).toRealPath(new LinkOption[0]);
            LicencePathFinder licenceFinder = new LicencePathFinder(workingDir);
            return Licence.findAndCheckLicence(Clock.systemUTC(), reportDir, data.getProjectBase(), licenceFinder, "EXTENSIONS");
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException while looking for licence");
        }
    }
}

