/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.exclusions.analysis;

import com.groupcdg.arcmutate.exclusions.analysis.DirectoryLocator;
import com.groupcdg.arcmutate.exclusions.analysis.Locator;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.classinfo.ClassName;

public class CompoundLocator
implements Locator {
    private final Collection<Locator> children;

    public CompoundLocator(Collection<Path> roots) {
        this.children = roots.stream().map(f -> new DirectoryLocator((Path)f)).collect(Collectors.toList());
    }

    @Override
    public Optional<Path> locate(List<String> classes, String fileName) {
        List matches = this.children.stream().flatMap(c -> CompoundLocator.optionalToStream(c.locate(classes, fileName))).collect(Collectors.toList());
        if (matches.isEmpty()) {
            return Optional.empty();
        }
        if (matches.size() == 1) {
            return Optional.of((Path)matches.get(0));
        }
        ClassName pckg = ClassName.fromString((String)classes.get(0)).getPackage();
        String fullName = DirectoryLocator.toFileName(pckg, fileName);
        return matches.stream().filter(p -> p.toString().endsWith(fullName)).findAny();
    }

    private static <T> Stream<T> optionalToStream(Optional<T> opt) {
        if (opt.isPresent()) {
            return Stream.of(opt.get());
        }
        return Stream.empty();
    }
}

