/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.interfaces;

import com.greatmancode.craftconomy3.tools.ServerType;
import com.greatmancode.craftconomy3.tools.caller.bukkit.BukkitServerCaller;
import com.greatmancode.craftconomy3.tools.commands.interfaces.CommandReceiver;
import com.greatmancode.craftconomy3.tools.configuration.bukkit.BukkitConfig;
import com.greatmancode.craftconomy3.tools.events.EventManager;
import com.greatmancode.craftconomy3.tools.interfaces.Common;
import com.greatmancode.craftconomy3.tools.interfaces.Loader;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitLoader
extends JavaPlugin
implements Loader {
    private Common common;
    private EventManager eventManager;
    private CommandReceiver commandReceiver;

    @Override
    public void onEnable() {
        BukkitServerCaller bukkitCaller = new BukkitServerCaller(this);
        this.eventManager = new EventManager(bukkitCaller);
        BukkitConfig bukkitConfig = new BukkitConfig(this.getClass().getResourceAsStream("/loader.yml"), bukkitCaller);
        String mainClass = bukkitConfig.getString("main-class");
        try {
            Class<?> clazz = Class.forName(mainClass);
            if (Common.class.isAssignableFrom(clazz)) {
                this.common = (Common)clazz.newInstance();
                this.common.onEnable(bukkitCaller, this.getLogger());
            } else {
                this.getLogger().severe("The class " + mainClass + " is invalid!");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
            }
        }
        catch (ClassNotFoundException e) {
            this.getLogger().log(Level.SEVERE, "Unable to load the main class!", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        catch (InstantiationException e) {
            this.getLogger().log(Level.SEVERE, "Unable to load the main class!", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        catch (IllegalAccessException e) {
            this.getLogger().log(Level.SEVERE, "Unable to load the main class!", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    @Override
    public void onDisable() {
        this.common.onDisable();
    }

    @Override
    public ServerType getServerType() {
        return ServerType.BUKKIT;
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public Common getCommon() {
        return this.common;
    }

    @Override
    public CommandReceiver getCommandReceiver() {
        return this.commandReceiver;
    }

    @Override
    public void setCommandReceiver(CommandReceiver commandReceiver) {
        this.commandReceiver = commandReceiver;
    }
}

