/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.configuration.sponge;

import com.greatmancode.craftconomy3.tools.configuration.Config;
import com.greatmancode.craftconomy3.tools.interfaces.caller.ServerCaller;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;

public class SpongeConfig
extends Config {
    private CommentedConfigurationNode file;
    private HoconConfigurationLoader loader;

    public SpongeConfig(InputStream is, ServerCaller serverCaller) {
        super(is, serverCaller);
    }

    public SpongeConfig(File folder, String fileName, ServerCaller serverCaller) {
        super(folder, fileName, serverCaller);
        try {
            this.loader = HoconConfigurationLoader.builder().setFile(new File(folder, fileName)).build();
            this.file = (CommentedConfigurationNode)this.loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getInt(String path) {
        return this.file.getNode(new Object[]{path}).getInt();
    }

    @Override
    public long getLong(String path) {
        return this.file.getNode(new Object[]{path}).getLong();
    }

    @Override
    public double getDouble(String path) {
        return this.file.getNode(new Object[]{path}).getDouble();
    }

    @Override
    public String getString(String path) {
        return this.file.getNode(new Object[]{path}).getString();
    }

    @Override
    public boolean getBoolean(String path) {
        return this.file.getNode(new Object[]{path}).getBoolean();
    }

    @Override
    public void setValue(String path, Object value) {
        this.file.getNode(new Object[]{path}).setValue(value);
        try {
            this.loader.save((ConfigurationNode)this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean has(String path) {
        return !this.file.getNode(new Object[]{path}).isVirtual();
    }

    @Override
    public Map<String, String> getStringMap(String path) {
        HashMap<String, String> map = new HashMap<String, String>();
        Set childrens = path.equals("") ? this.file.getChildrenMap().entrySet() : this.file.getNode(new Object[]{path}).getChildrenMap().entrySet();
        for (Map.Entry entry : childrens) {
            map.put(entry.getKey().toString(), ((CommentedConfigurationNode)entry.getValue()).getString());
        }
        return map;
    }

    @Override
    public List<String> getStringList(String path) {
        return null;
    }
}

