/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.caller.sponge;

import com.google.common.base.Optional;
import com.greatmancode.craftconomy3.tools.caller.sponge.SpongePlayerCaller;
import com.greatmancode.craftconomy3.tools.caller.sponge.SpongeSchedulerCaller;
import com.greatmancode.craftconomy3.tools.commands.SubCommand;
import com.greatmancode.craftconomy3.tools.events.Event;
import com.greatmancode.craftconomy3.tools.interfaces.Common;
import com.greatmancode.craftconomy3.tools.interfaces.SpongeLoader;
import com.greatmancode.craftconomy3.tools.interfaces.caller.ServerCaller;
import com.greatmancode.craftconomy3.tools.utils.ServicePriority;
import com.greatmancode.craftconomy3.tools.utils.VaultEconomy;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.api.Game;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextBuilder;
import org.spongepowered.api.text.Texts;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.command.CommandCallable;
import org.spongepowered.api.util.command.CommandException;
import org.spongepowered.api.util.command.CommandResult;
import org.spongepowered.api.util.command.CommandSource;
import org.spongepowered.api.util.command.source.ConsoleSource;
import org.spongepowered.api.world.World;

public class SpongeServerCaller
extends ServerCaller {
    private String name;
    private String version;

    public SpongeServerCaller(SpongeLoader spongeLoader, String name, String version) {
        super(spongeLoader);
        this.addPlayerCaller(new SpongePlayerCaller(this));
        this.addSchedulerCaller(new SpongeSchedulerCaller(this));
        this.name = name;
        this.version = version;
    }

    @Override
    public void disablePlugin() {
    }

    @Override
    public String addColor(String message) {
        return message;
    }

    public Text addColorSponge(String message) {
        message = this.getCommandPrefix() + message;
        TextBuilder textMain = Texts.builder();
        Matcher m = Pattern.compile("(\\{\\{([^\\{\\}]+)\\}\\}|[^\\{\\}]+)").matcher(message);
        TextColor.Base color = null;
        TextStyle.Base style = null;
        while (m.find()) {
            String entry = m.group();
            if (entry.contains("{{")) {
                color = null;
                style = null;
                switch (entry) {
                    case "{{BLACK}}": {
                        color = TextColors.BLACK;
                        break;
                    }
                    case "{{DARK_BLUE}}": {
                        color = TextColors.DARK_BLUE;
                        break;
                    }
                    case "{{DARK_GREEN}}": {
                        color = TextColors.DARK_GREEN;
                        break;
                    }
                    case "{{DARK_CYAN}}": {
                        color = TextColors.DARK_AQUA;
                        break;
                    }
                    case "{{DARK_RED}}": {
                        color = TextColors.DARK_RED;
                        break;
                    }
                    case "{{PURPLE}}": {
                        color = TextColors.DARK_PURPLE;
                        break;
                    }
                    case "{{GOLD}}": {
                        color = TextColors.GOLD;
                        break;
                    }
                    case "{{GRAY}}": {
                        color = TextColors.GRAY;
                        break;
                    }
                    case "{{DARK_GRAY}}": {
                        color = TextColors.DARK_GRAY;
                        break;
                    }
                    case "{{BLUE}}": {
                        color = TextColors.AQUA;
                        break;
                    }
                    case "{{BRIGHT_GREEN}}": {
                        color = TextColors.GREEN;
                        break;
                    }
                    case "{{CYAN}}": {
                        color = TextColors.AQUA;
                        break;
                    }
                    case "{{RED}}": {
                        color = TextColors.RED;
                        break;
                    }
                    case "{{LIGHT_PURPLE}}": {
                        color = TextColors.LIGHT_PURPLE;
                        break;
                    }
                    case "{{YELLOW}}": {
                        color = TextColors.YELLOW;
                        break;
                    }
                    case "{{WHITE}}": {
                        color = TextColors.WHITE;
                        break;
                    }
                    case "{{OBFUSCATED}}": {
                        style = TextStyles.OBFUSCATED;
                        break;
                    }
                    case "{{BOLD}}": {
                        style = TextStyles.BOLD;
                        break;
                    }
                    case "{{STRIKETHROUGH}}": {
                        style = TextStyles.STRIKETHROUGH;
                        break;
                    }
                    case "{{UNDERLINE}}": {
                        style = TextStyles.UNDERLINE;
                        break;
                    }
                    case "{{ITALIC}}": {
                        style = TextStyles.ITALIC;
                        break;
                    }
                    case "{{RESET}}": {
                        style = TextStyles.RESET;
                    }
                }
                continue;
            }
            TextBuilder.Literal text = Texts.builder((String)entry);
            if (color != null) {
                text.color(color);
            }
            if (style != null) {
                text.style(new TextStyle[]{style});
            }
            textMain.append(new Text[]{text.build()});
        }
        return textMain.build();
    }

    @Override
    public boolean worldExist(String worldName) {
        return ((SpongeLoader)this.loader).getGame().getServer().getWorld(worldName) != null;
    }

    @Override
    public String getDefaultWorld() {
        return ((World)((SpongeLoader)this.loader).getGame().getServer().getWorlds().iterator().next()).getName();
    }

    @Override
    public File getDataFolder() {
        File data = new File("mods" + File.separator + "Craftconomy3");
        data.mkdirs();
        return data;
    }

    @Override
    public void addCommand(String name, String help, final SubCommand subCommand) {
        CommandCallable command = new CommandCallable(){

            public Optional<CommandResult> process(CommandSource source, String arguments) throws CommandException {
                String[] newArgs;
                String subCommandValue = "";
                String[] args = arguments.split(" ");
                if (args.length <= 1) {
                    newArgs = new String[]{};
                    if (args.length != 0) {
                        subCommandValue = args[0];
                    }
                } else {
                    newArgs = new String[args.length - 1];
                    subCommandValue = args[0];
                    System.arraycopy(args, 1, newArgs, 0, args.length - 1);
                }
                String username = source.getName();
                if (source instanceof ConsoleSource) {
                    username = "console";
                }
                subCommand.execute(subCommandValue, username, newArgs);
                return Optional.of((Object)CommandResult.success());
            }

            public List<String> getSuggestions(CommandSource source, String arguments) throws CommandException {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(subCommand.getSubCommandKeys());
                return list;
            }

            public boolean testPermission(CommandSource source) {
                return true;
            }

            public Optional<Text> getShortDescription(CommandSource source) {
                return Optional.absent();
            }

            public Optional<Text> getHelp(CommandSource source) {
                return Optional.absent();
            }

            public Text getUsage(CommandSource source) {
                return Texts.of();
            }
        };
        ((SpongeLoader)this.loader).getGame().getCommandDispatcher().register((Object)this.loader, command, new String[]{name});
    }

    @Override
    public String getServerVersion() {
        return String.format("%s %s", "Sponge", ((SpongeLoader)this.loader).getGame().getPlatform().getVersion());
    }

    @Override
    public String getPluginVersion() {
        return this.version;
    }

    @Override
    public String getPluginName() {
        return this.name;
    }

    @Override
    public void loadLibrary(String path) {
    }

    @Override
    public void registerPermission(String permissionNode) {
    }

    @Override
    public boolean isOnlineMode() {
        return ((SpongeLoader)this.loader).getGame().getServer().getOnlineMode();
    }

    @Override
    public Logger getLogger() {
        return Logger.getLogger(this.getPluginName());
    }

    @Override
    public void throwEvent(Event event) {
    }

    @Override
    public Common retrievePlugin(String name) {
        Game game = ((SpongeLoader)this.loader).getGame();
        return (Common)((PluginContainer)game.getPluginManager().getPlugin(name).get()).getInstance();
    }

    @Override
    public void setVaultEconomyHook(VaultEconomy instance, ServicePriority priority) {
    }
}

