/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.caller.sponge;

import com.greatmancode.craftconomy3.tools.caller.sponge.SpongeServerCaller;
import com.greatmancode.craftconomy3.tools.interfaces.SpongeLoader;
import com.greatmancode.craftconomy3.tools.interfaces.caller.PlayerCaller;
import com.greatmancode.craftconomy3.tools.interfaces.caller.ServerCaller;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.spongepowered.api.entity.player.Player;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.text.Text;

public class SpongePlayerCaller
extends PlayerCaller {
    private SpongeLoader loader;

    public SpongePlayerCaller(ServerCaller caller) {
        super(caller);
        this.loader = (SpongeLoader)caller.getLoader();
    }

    @Override
    public boolean checkPermission(String playerName, String perm) {
        if (playerName.equals("console")) {
            return true;
        }
        UUID uuid = this.getUUID(playerName);
        return ((PermissionService)this.loader.getGame().getServiceManager().provide(PermissionService.class).get()).getUserSubjects().get(uuid.toString()).hasPermission(perm);
    }

    @Override
    public void sendMessage(String playerName, String message) {
        if (playerName.equals("console")) {
            this.caller.getLogger().info(message);
            return;
        }
        ((Player)this.loader.getGame().getServer().getPlayer(playerName).get()).sendMessage(new Text[]{((SpongeServerCaller)this.getCaller()).addColorSponge(message)});
    }

    @Override
    public String getPlayerWorld(String playerName) {
        return ((Player)this.loader.getGame().getServer().getPlayer(playerName).get()).getWorld().getName();
    }

    @Override
    public String getPlayerWorld(UUID uuid) {
        return ((Player)this.loader.getGame().getServer().getPlayer(uuid).get()).getWorld().getName();
    }

    @Override
    public boolean isOnline(String playerName) {
        return this.loader.getGame().getServer().getPlayer(playerName).isPresent();
    }

    @Override
    public List<String> getOnlinePlayers() {
        ArrayList<String> playerList = new ArrayList<String>();
        for (Player p : this.loader.getGame().getServer().getOnlinePlayers()) {
            playerList.add(p.getName());
        }
        return playerList;
    }

    @Override
    public boolean isOp(String playerName) {
        return false;
    }

    @Override
    public UUID getUUID(String playerName) {
        return ((Player)this.loader.getGame().getServer().getPlayer(playerName).get()).getUniqueId();
    }
}

