/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.storage.sql;

import com.greatmancode.com.zaxxer.libs.hikari.HikariConfig;
import com.greatmancode.com.zaxxer.libs.hikari.HikariDataSource;
import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.storage.sql.SQLStorageEngine;
import com.greatmancode.craftconomy3.storage.sql.tables.AccessTable;
import com.greatmancode.craftconomy3.storage.sql.tables.AccountTable;
import com.greatmancode.craftconomy3.storage.sql.tables.BalanceTable;
import com.greatmancode.craftconomy3.storage.sql.tables.ConfigTable;
import com.greatmancode.craftconomy3.storage.sql.tables.CurrencyTable;
import com.greatmancode.craftconomy3.storage.sql.tables.ExchangeTable;
import com.greatmancode.craftconomy3.storage.sql.tables.LogTable;
import com.greatmancode.craftconomy3.storage.sql.tables.WorldGroupTable;
import com.greatmancode.craftconomy3.tools.utils.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class MySQLEngine
extends SQLStorageEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MySQLEngine() {
        block5: {
            HikariConfig config = new HikariConfig();
            config.setMaximumPoolSize(Common.getInstance().getMainConfig().getInt("System.Database.Poolsize"));
            config.setDataSourceClassName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
            config.addDataSourceProperty("serverName", Common.getInstance().getMainConfig().getString("System.Database.Address"));
            config.addDataSourceProperty("port", Common.getInstance().getMainConfig().getString("System.Database.Port"));
            config.addDataSourceProperty("databaseName", Common.getInstance().getMainConfig().getString("System.Database.Db"));
            config.addDataSourceProperty("user", Common.getInstance().getMainConfig().getString("System.Database.Username"));
            config.addDataSourceProperty("password", Common.getInstance().getMainConfig().getString("System.Database.Password"));
            config.addDataSourceProperty("autoDeserialize", true);
            config.setConnectionTimeout(5000L);
            this.db = new HikariDataSource(config);
            this.tablePrefix = Common.getInstance().getMainConfig().getString("System.Database.Prefix");
            this.accessTable = new AccessTable(this.tablePrefix);
            this.accountTable = new AccountTable(this.tablePrefix);
            this.balanceTable = new BalanceTable(this.tablePrefix);
            this.configTable = new ConfigTable(this.tablePrefix);
            this.currencyTable = new CurrencyTable(this.tablePrefix);
            this.exchangeTable = new ExchangeTable(this.tablePrefix);
            this.logTable = new LogTable(this.tablePrefix);
            this.worldGroupTable = new WorldGroupTable(this.tablePrefix);
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.accountTable.createTableMySQL);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.currencyTable.createTableMySQL);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.configTable.createTableMySQL);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.worldGroupTable.createTableMySQL);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.balanceTable.createTableMySQL);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.logTable.createTableMySQL);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.accessTable.createTableMySQL);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.exchangeTable.createTableMySQL);
                statement.executeUpdate();
                statement.close();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }
}

