/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.storage;

import com.greatmancode.craftconomy3.Cause;
import com.greatmancode.craftconomy3.LogInfo;
import com.greatmancode.craftconomy3.account.Account;
import com.greatmancode.craftconomy3.account.AccountACLValue;
import com.greatmancode.craftconomy3.account.Balance;
import com.greatmancode.craftconomy3.commands.currency.CurrencyRatesCommand;
import com.greatmancode.craftconomy3.commands.money.LogCommand;
import com.greatmancode.craftconomy3.commands.money.TopCommand;
import com.greatmancode.craftconomy3.converter.Converter;
import com.greatmancode.craftconomy3.currency.Currency;
import com.greatmancode.craftconomy3.groups.WorldGroup;
import com.greatmancode.craftconomy3.utils.NoExchangeRate;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class StorageEngine {
    public abstract void disable();

    public Account getAccount(String name, boolean isBank) {
        return this.getAccount(name, isBank, true);
    }

    public abstract Account getAccount(String var1, boolean var2, boolean var3);

    public abstract Account getAccount(UUID var1);

    public abstract List<String> getAllAccounts(boolean var1);

    public abstract void saveLog(LogInfo var1, Cause var2, String var3, Account var4, double var5, Currency var7, String var8);

    public abstract void saveLog(LogInfo var1, Cause var2, String var3, Account var4, double var5, Currency var7, String var8, Timestamp var9);

    public abstract String getConfigEntry(String var1);

    public abstract void setConfigEntry(String var1, String var2);

    public abstract List<Balance> getAllBalance(Account var1);

    public abstract List<Balance> getAllWorldBalance(Account var1, String var2);

    public abstract double getBalance(Account var1, Currency var2, String var3);

    public abstract double setBalance(Account var1, double var2, Currency var4, String var5);

    public abstract void setInfiniteMoney(Account var1, boolean var2);

    public abstract void setIgnoreACL(Account var1, boolean var2);

    public abstract Map<String, AccountACLValue> retrieveACL(Account var1);

    public abstract AccountACLValue saveACL(Account var1, String var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7);

    public abstract double getExchangeRate(Currency var1, Currency var2) throws NoExchangeRate;

    public abstract void setExchangeRate(Currency var1, Currency var2, double var3);

    public abstract void saveCurrency(String var1, Currency var2);

    public abstract void deleteCurrency(Currency var1);

    public abstract void updateUsername(String var1, UUID var2);

    public abstract void updateUUID(String var1, UUID var2);

    public abstract Map<String, WorldGroup> getWorldGroups();

    public abstract void removeWorldGroup(String var1);

    public abstract String[] getBankAccountList(String var1);

    public abstract List<LogCommand.LogEntry> getLog(Account var1, int var2);

    public abstract List<TopCommand.TopEntry> getTopEntry(int var1, Currency var2, String var3);

    public abstract List<CurrencyRatesCommand.CurrencyRateEntry> getCurrencyExchanges();

    public abstract void cleanLog(Timestamp var1);

    public abstract boolean deleteAccount(String var1, boolean var2);

    public abstract boolean accountExist(String var1, boolean var2);

    public abstract void saveWorldGroup(String var1, String var2);

    public abstract List<String> getAllCurrencyNames();

    public abstract void setDefaultCurrency(Currency var1);

    public abstract void setDefaultBankCurrency(Currency var1);

    public abstract Currency getCurrency(String var1);

    public abstract Map<String, Currency> getAllCurrencies();

    public abstract String retrieveWorldGroupWorlds(String var1);

    public abstract void saveImporterUsers(List<Converter.User> var1);

    public abstract void disableAutoCommit();

    public abstract void enableAutoCommit();

    public abstract void commit();
}

