/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.groups;

import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.groups.WorldGroup;
import java.util.Map;

public class WorldGroupsManager {
    public static final String DEFAULT_GROUP_NAME = "default";
    private final Map<String, WorldGroup> list = Common.getInstance().getStorageHandler().getStorageEngine().getWorldGroups();

    public WorldGroupsManager() {
        Common.getInstance().addMetricsGraph("WorldGroupCount", this.list.size() + "");
    }

    public void addWorldToGroup(String groupName, String world) {
        if (!groupName.equalsIgnoreCase(DEFAULT_GROUP_NAME)) {
            if (this.list.containsKey(groupName)) {
                this.list.get(groupName).addWorld(world);
            } else {
                WorldGroup group = new WorldGroup(groupName);
                group.addWorld(world);
            }
        }
    }

    public String getWorldGroupName(String world) {
        String result = DEFAULT_GROUP_NAME;
        for (Map.Entry<String, WorldGroup> entry : this.list.entrySet()) {
            if (!entry.getValue().worldExist(world)) continue;
            result = entry.getKey();
        }
        return result;
    }

    public void removeWorldFromGroup(String world) {
        String groupName = this.getWorldGroupName(world);
        if (!groupName.equals(DEFAULT_GROUP_NAME)) {
            this.list.get(groupName).removeWorld(world);
        }
    }

    public void removeGroup(String group) {
        if (this.worldGroupExist(group)) {
            Common.getInstance().getStorageHandler().getStorageEngine().removeWorldGroup(group);
            this.list.remove(group);
        }
    }

    public boolean worldGroupExist(String name) {
        return this.list.containsKey(name);
    }

    public void addWorldGroup(String name) {
        if (!this.worldGroupExist(name)) {
            this.list.put(name, new WorldGroup(name));
        }
    }
}

