/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.groups;

import com.greatmancode.craftconomy3.Common;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class WorldGroup {
    private String name;
    private List<String> worldList = new ArrayList<String>();

    public WorldGroup(String name) {
        this.name = name;
        Collections.addAll(this.worldList, Common.getInstance().getStorageHandler().getStorageEngine().retrieveWorldGroupWorlds(name).split(","));
    }

    public void addWorld(String name) {
        if (name != null && Common.getInstance().getServerCaller().worldExist(name) && !this.worldExist(name)) {
            this.worldList.add(name);
            this.save();
        }
    }

    public void removeWorld(String world) {
        if (this.worldList.contains(world)) {
            this.worldList.remove(world);
            this.save();
        }
    }

    public boolean worldExist(String worldName) {
        return this.worldList.contains(worldName);
    }

    private void save() {
        String save = "";
        Iterator<String> iterator = this.worldList.iterator();
        while (iterator.hasNext()) {
            save = save + iterator.next();
            if (!iterator.hasNext()) continue;
            save = save + ",";
        }
        Common.getInstance().getStorageHandler().getStorageEngine().saveWorldGroup(this.name, save);
    }
}

