/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.converter.converters;

import com.greatmancode.com.zaxxer.libs.hikari.HikariConfig;
import com.greatmancode.com.zaxxer.libs.hikari.HikariDataSource;
import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.converter.Converter;
import com.greatmancode.craftconomy3.tools.utils.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class Iconomy6
extends Converter {
    private BufferedReader flatFileReader = null;
    private HikariDataSource db;

    public Iconomy6() {
        this.getDbTypes().add("flatfile");
        this.getDbTypes().add("minidb");
        this.getDbTypes().add("sqlite");
        this.getDbTypes().add("mysql");
        this.getDbTypes().add("h2");
    }

    @Override
    public List<String> getDbInfo() {
        if (this.getDbInfoList().size() == 0) {
            if ("flatfile".equals(this.getSelectedDbType()) || "minidb".equals(this.getSelectedDbType()) || "sqlite".equals(this.getSelectedDbType())) {
                this.getDbInfoList().add("filename");
            } else if ("mysql".equals(this.getSelectedDbType())) {
                this.getDbInfoList().add("address");
                this.getDbInfoList().add("port");
                this.getDbInfoList().add("username");
                this.getDbInfoList().add("password");
                this.getDbInfoList().add("database");
            } else if ("h2".equals(this.getSelectedDbType())) {
                this.getDbInfoList().add("tablename");
                this.getDbInfoList().add("filename");
            }
        }
        return this.getDbInfoList();
    }

    @Override
    public boolean connect() {
        boolean result = false;
        if ("flatfile".equals(this.getSelectedDbType()) || "minidb".equals(this.getSelectedDbType())) {
            result = this.loadFile();
        } else if ("mysql".equals(this.getSelectedDbType())) {
            this.loadMySQL();
        } else if ("sqlite".equals(this.getSelectedDbType())) {
            this.loadSQLite();
        } else if ("h2".equals(this.getSelectedDbType())) {
            this.loadH2();
        }
        if (this.db != null) {
            result = true;
        }
        return result;
    }

    private boolean loadFile() {
        boolean result = false;
        File dbFile = new File(Common.getInstance().getServerCaller().getDataFolder(), this.getDbConnectInfo().get("filename"));
        if (dbFile.exists()) {
            try {
                this.flatFileReader = new BufferedReader(new FileReader(dbFile));
                result = true;
            }
            catch (FileNotFoundException e) {
                Common.getInstance().getLogger().severe("iConomy database file not found!");
            }
        }
        return result;
    }

    private void loadMySQL() {
        try {
            HikariConfig config = new HikariConfig();
            config.setMaximumPoolSize(10);
            config.setDataSourceClassName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
            config.addDataSourceProperty("serverName", this.getDbConnectInfo().get("address"));
            config.addDataSourceProperty("port", this.getDbConnectInfo().get("port"));
            config.addDataSourceProperty("databaseName", this.getDbConnectInfo().get("database"));
            config.addDataSourceProperty("user", this.getDbConnectInfo().get("username"));
            config.addDataSourceProperty("password", this.getDbConnectInfo().get("password"));
            config.addDataSourceProperty("autoDeserialize", true);
            this.db = new HikariDataSource(config);
        }
        catch (NumberFormatException e) {
            Common.getInstance().getLogger().severe("Illegal Port!");
        }
    }

    private void loadH2() {
        HikariConfig config = new HikariConfig();
        config.setMaximumPoolSize(10);
        config.setDataSourceClassName("org.h2.jdbcx.JdbcDataSource");
        config.addDataSourceProperty("user", "sa");
        config.addDataSourceProperty("password", "sa");
        config.addDataSourceProperty("url", "jdbc:h2:file:" + new File(Common.getInstance().getServerCaller().getDataFolder().getPath(), this.getDbConnectInfo().get("filename")).getAbsolutePath() + ";MV_STORE=FALSE");
        this.db = new HikariDataSource(config);
    }

    private void loadSQLite() {
    }

    @Override
    public boolean importData(String sender) {
        boolean result = false;
        if (this.flatFileReader != null) {
            result = this.importFlatFile(sender);
        } else if (this.db != null) {
            result = this.importDatabase(sender);
        }
        return result;
    }

    private boolean importFlatFile(String sender) {
        boolean result = false;
        try {
            String str;
            ArrayList<String> file = new ArrayList<String>();
            while ((str = this.flatFileReader.readLine()) != null) {
                file.add(str);
            }
            this.flatFileReader.close();
            ArrayList<Converter.User> userList = new ArrayList<Converter.User>();
            for (String aFile : file) {
                Object[] info = aFile.split(" ");
                try {
                    double balance = Double.parseDouble(info[1].split(":")[1]);
                    userList.add(new Converter.User((String)info[0], balance));
                }
                catch (NumberFormatException e) {
                    Common.getInstance().sendConsoleMessage(Level.SEVERE, "User " + (String)info[0] + " have a invalid balance" + (String)info[1]);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Common.getInstance().sendConsoleMessage(Level.WARNING, "Line not formatted correctly. I read:" + Arrays.toString(info));
                }
            }
            this.addAccountToString(sender, userList);
            result = true;
        }
        catch (IOException e) {
            Common.getInstance().getLogger().severe("A error occured while reading the iConomy database file! Message: " + e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importDatabase(String sender) {
        block6: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = this.getDbConnectInfo().get("tablename") != null ? connection.prepareStatement("SELECT * FROM " + this.getDbConnectInfo().get("tablename")) : connection.prepareStatement("SELECT * FROM iConomy");
                ResultSet set = statement.executeQuery();
                ArrayList<Converter.User> userList = new ArrayList<Converter.User>();
                while (set.next()) {
                    userList.add(new Converter.User(set.getString("username"), set.getDouble("balance")));
                }
                this.addAccountToString(sender, userList);
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return true;
    }
}

