/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.commands.money;

import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.commands.money.TopCommandThread;
import com.greatmancode.craftconomy3.currency.Currency;
import com.greatmancode.craftconomy3.tools.commands.interfaces.CommandExecutor;

public class TopCommand
extends CommandExecutor {
    @Override
    public void execute(String sender, String[] args) {
        Currency currency;
        int page = 1;
        if (args.length == 0) {
            currency = Common.getInstance().getCurrencyManager().getDefaultCurrency();
        } else if (Common.getInstance().getCurrencyManager().getCurrency(args[0]) != null) {
            currency = Common.getInstance().getCurrencyManager().getCurrency(args[0]);
        } else {
            Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, Common.getInstance().getLanguageManager().getString("currency_not_exist"));
            return;
        }
        if (args.length > 1) {
            try {
                page = Integer.parseInt(args[1]);
                if (page < 1) {
                    page = 1;
                }
            }
            catch (NumberFormatException e) {
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, Common.getInstance().getLanguageManager().getString("invalid_page"));
                return;
            }
        }
        String world = "default";
        if (args.length > 2) {
            world = args[2];
        }
        Common.getInstance().getServerCaller().getSchedulerCaller().delay(new TopCommandThread(sender, page, world, currency), 0L, false);
    }

    @Override
    public String help() {
        return Common.getInstance().getLanguageManager().getString("money_top_cmd_help");
    }

    @Override
    public int maxArgs() {
        return 3;
    }

    @Override
    public int minArgs() {
        return 0;
    }

    @Override
    public boolean playerOnly() {
        return false;
    }

    @Override
    public String getPermissionNode() {
        return "craftconomy.money.top";
    }

    public static class TopEntry {
        public String username;
        public Currency currency;
        public double balance;

        public TopEntry(String username, Currency currency, double balance) {
            this.username = username;
            this.currency = currency;
            this.balance = balance;
        }
    }
}

