/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.commands.money;

import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.account.Account;
import com.greatmancode.craftconomy3.commands.money.LogCommandThread;
import com.greatmancode.craftconomy3.currency.Currency;
import com.greatmancode.craftconomy3.tools.commands.interfaces.CommandExecutor;
import java.sql.Timestamp;

public class LogCommand
extends CommandExecutor {
    @Override
    public void execute(String sender, String[] args) {
        int page = 1;
        if (args.length >= 1) {
            try {
                page = Integer.parseInt(args[0]);
                if (page < 1) {
                    page = 1;
                }
            }
            catch (NumberFormatException e) {
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, Common.getInstance().getLanguageManager().getString("invalid_page"));
                return;
            }
        }
        Account user = Common.getInstance().getAccountManager().getAccount(sender, false);
        if (args.length == 2 && Common.getInstance().getServerCaller().getPlayerCaller().checkPermission(sender, "craftconomy.money.log.others") && Common.getInstance().getAccountManager().exist(args[1], false)) {
            user = Common.getInstance().getAccountManager().getAccount(args[1], false);
        }
        Common.getInstance().getServerCaller().getSchedulerCaller().delay(new LogCommandThread(sender, page, user), 0L, false);
    }

    @Override
    public String help() {
        return Common.getInstance().getLanguageManager().getString("money_log_cmd_help");
    }

    @Override
    public int maxArgs() {
        return 2;
    }

    @Override
    public int minArgs() {
        return 0;
    }

    @Override
    public boolean playerOnly() {
        return false;
    }

    @Override
    public String getPermissionNode() {
        return "craftconomy.money.log";
    }

    public static class LogEntry {
        public Timestamp timestamp;
        public String type;
        public String worldName;
        public String cause;
        public String causeReason;
        public Currency currency;
        public double amount;

        public LogEntry(Timestamp timestamp, String type, String worldName, String cause, String causeReason, Currency currency, double amount) {
            this.timestamp = timestamp;
            this.type = type;
            this.worldName = worldName;
            this.cause = cause;
            this.causeReason = causeReason;
            this.currency = currency;
            this.amount = amount;
        }
    }
}

