/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.account;

import com.greatmancode.craftconomy3.Cause;
import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.LogInfo;
import com.greatmancode.craftconomy3.account.AccountACL;
import com.greatmancode.craftconomy3.account.Balance;
import com.greatmancode.craftconomy3.currency.Currency;
import com.greatmancode.craftconomy3.tools.events.event.EconomyChangeEvent;
import java.util.List;

public class Account {
    private int id;
    private AccountACL acl;
    private boolean bankAccount;
    private boolean infiniteMoney;
    private boolean ignoreACL;
    private String name;

    public Account(int id, String name, boolean bankAccount, boolean infiniteMoney, boolean ignoreACL) {
        this.id = id;
        this.name = name;
        this.bankAccount = bankAccount;
        this.infiniteMoney = infiniteMoney;
        this.ignoreACL = ignoreACL;
        if (this.isBankAccount()) {
            this.acl = new AccountACL(this);
        }
    }

    public String getAccountName() {
        return this.name;
    }

    public boolean isBankAccount() {
        return this.bankAccount;
    }

    public AccountACL getAccountACL() {
        AccountACL accountAcl = null;
        if (this.isBankAccount()) {
            accountAcl = this.acl;
        }
        return accountAcl;
    }

    public List<Balance> getAllBalance() {
        return Common.getInstance().getStorageHandler().getStorageEngine().getAllBalance(this);
    }

    public List<Balance> getAllWorldBalance(String world) {
        if (!Common.getInstance().getWorldGroupManager().worldGroupExist(world)) {
            world = Common.getInstance().getWorldGroupManager().getWorldGroupName(world);
        }
        return Common.getInstance().getStorageHandler().getStorageEngine().getAllWorldBalance(this, world);
    }

    public double getBalance(String world, String currencyName) {
        Currency currency;
        double balance = Double.MIN_NORMAL;
        if (!Common.getInstance().getWorldGroupManager().worldGroupExist(world)) {
            world = Common.getInstance().getWorldGroupManager().getWorldGroupName(world);
        }
        if ((currency = Common.getInstance().getCurrencyManager().getCurrency(currencyName)) != null) {
            balance = !this.hasInfiniteMoney() ? Common.getInstance().getStorageHandler().getStorageEngine().getBalance(this, currency, world) : Double.MAX_VALUE;
        }
        return Account.format(balance);
    }

    @Deprecated
    public double deposit(double amount, String world, String currencyName) {
        return this.deposit(amount, world, currencyName, Cause.UNKNOWN, null);
    }

    public double deposit(double amount, String world, String currencyName, Cause cause, String causeReason) {
        Currency currency;
        double result = this.getBalance(world, currencyName) + Account.format(amount);
        if (!Common.getInstance().getWorldGroupManager().worldGroupExist(world)) {
            world = Common.getInstance().getWorldGroupManager().getWorldGroupName(world);
        }
        if ((currency = Common.getInstance().getCurrencyManager().getCurrency(currencyName)) != null) {
            if (!this.hasInfiniteMoney()) {
                result = Common.getInstance().getStorageHandler().getStorageEngine().setBalance(this, result, currency, world);
                Common.getInstance().writeLog(LogInfo.DEPOSIT, cause, causeReason, this, amount, currency, world);
                Common.getInstance().getServerCaller().throwEvent(new EconomyChangeEvent(this.getAccountName(), result));
            } else {
                result = Double.MAX_VALUE;
            }
        }
        return Account.format(result);
    }

    @Deprecated
    public double withdraw(double amount, String world, String currencyName) {
        return this.withdraw(amount, world, currencyName, Cause.UNKNOWN, null);
    }

    public double withdraw(double amount, String world, String currencyName, Cause cause, String causeReason) {
        Currency currency;
        double result = this.getBalance(world, currencyName) - Account.format(amount);
        if (!Common.getInstance().getWorldGroupManager().worldGroupExist(world)) {
            world = Common.getInstance().getWorldGroupManager().getWorldGroupName(world);
        }
        if ((currency = Common.getInstance().getCurrencyManager().getCurrency(currencyName)) != null) {
            if (!this.hasInfiniteMoney()) {
                result = Common.getInstance().getStorageHandler().getStorageEngine().setBalance(this, result, currency, world);
                Common.getInstance().writeLog(LogInfo.WITHDRAW, cause, causeReason, this, amount, currency, world);
                Common.getInstance().getServerCaller().throwEvent(new EconomyChangeEvent(this.getAccountName(), result));
            } else {
                result = Double.MAX_VALUE;
            }
        }
        return Account.format(result);
    }

    @Deprecated
    public double set(double amount, String world, String currencyName) {
        return this.set(amount, world, currencyName, Cause.UNKNOWN, null);
    }

    public double set(double amount, String world, String currencyName, Cause cause, String causeReason) {
        Currency currency;
        double result = 0.0;
        if (!Common.getInstance().getWorldGroupManager().worldGroupExist(world)) {
            world = Common.getInstance().getWorldGroupManager().getWorldGroupName(world);
        }
        amount = Account.format(amount);
        if (!Common.getInstance().getWorldGroupManager().worldGroupExist(world)) {
            world = Common.getInstance().getWorldGroupManager().getWorldGroupName(world);
        }
        if ((currency = Common.getInstance().getCurrencyManager().getCurrency(currencyName)) != null && !this.hasInfiniteMoney()) {
            result = Common.getInstance().getStorageHandler().getStorageEngine().setBalance(this, amount, currency, world);
            Common.getInstance().writeLog(LogInfo.SET, cause, causeReason, this, amount, currency, world);
            Common.getInstance().getServerCaller().throwEvent(new EconomyChangeEvent(this.getAccountName(), result));
        }
        return Account.format(result);
    }

    public boolean hasEnough(double amount, String worldName, String currencyName) {
        Currency currency;
        boolean result = false;
        amount = Account.format(amount);
        if (!Common.getInstance().getWorldGroupManager().worldGroupExist(worldName)) {
            worldName = Common.getInstance().getWorldGroupManager().getWorldGroupName(worldName);
        }
        if ((currency = Common.getInstance().getCurrencyManager().getCurrency(currencyName)) != null && (this.getBalance(worldName, currencyName) >= amount || this.hasInfiniteMoney())) {
            result = true;
        }
        return result;
    }

    private static String getWorldPlayerCurrentlyIn(String playerName) {
        return Common.getInstance().getServerCaller().getPlayerCaller().getPlayerWorld(playerName);
    }

    public static String getWorldGroupOfPlayerCurrentlyIn(String playerName) {
        return Common.getInstance().getWorldGroupManager().getWorldGroupName(Account.getWorldPlayerCurrentlyIn(playerName));
    }

    public void setInfiniteMoney(boolean infinite) {
        Common.getInstance().getStorageHandler().getStorageEngine().setInfiniteMoney(this, infinite);
        this.infiniteMoney = infinite;
    }

    public boolean hasInfiniteMoney() {
        return this.infiniteMoney;
    }

    public static double format(double value) {
        if (value == Double.MAX_VALUE) {
            return value;
        }
        long factor = (long)Math.pow(10.0, 2.0);
        double tmp = Math.floor(value *= (double)factor);
        return tmp / (double)factor;
    }

    public boolean ignoreACL() {
        return this.ignoreACL;
    }

    public void setIgnoreACL(boolean ignore) {
        Common.getInstance().getStorageHandler().getStorageEngine().setIgnoreACL(this, ignore);
        this.ignoreACL = ignore;
    }

    public int getId() {
        return this.id;
    }
}

