/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.utils;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VersionChecker {
    private boolean oldVersion = false;
    private int newVersion = 0;

    public VersionChecker(String jobName, String currentVersion) {
        if (currentVersion.contains("unknown-unknown-unknown")) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "You are running a self-built version! Be sure that you check on the website if there's a new version!");
            return;
        }
        String pluginUrlString = "http://build.greatmancode.com/job/" + jobName + "/promotion/api/xml?depth=1";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            URL url = new URL(pluginUrlString);
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(url.openConnection().getInputStream());
            Node list = doc.getElementsByTagName("lastBuild").item(0);
            String buildURL = ((Element)list).getElementsByTagName("url").item(0).getTextContent();
            doc = factory.newDocumentBuilder().parse(buildURL + "api/xml?depth=1");
            Element entry = (Element)doc.getElementsByTagName("number").item(1);
            String data = entry.getTextContent();
            int buildNumber = Integer.parseInt(currentVersion.split("jenkins-Craftconomy3-")[1]);
            int jenkinsBuildNumber = Integer.parseInt(data);
            if (buildNumber < jenkinsBuildNumber) {
                this.oldVersion = true;
                this.newVersion = jenkinsBuildNumber;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error while trying to check for the latest version. The error is: " + e.getMessage());
        }
    }

    public boolean isOld() {
        return this.oldVersion;
    }

    public int getNewVersion() {
        return this.newVersion;
    }
}

