/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.events;

import com.greatmancode.craftconomy3.tools.caller.bukkit.BukkitServerCaller;
import com.greatmancode.craftconomy3.tools.caller.canary.CanaryServerCaller;
import com.greatmancode.craftconomy3.tools.caller.sponge.SpongeServerCaller;
import com.greatmancode.craftconomy3.tools.caller.unittest.UnitTestServerCaller;
import com.greatmancode.craftconomy3.tools.events.Event;
import com.greatmancode.craftconomy3.tools.events.ListenerRegistration;
import com.greatmancode.craftconomy3.tools.events.bukkit.BukkitEventManager;
import com.greatmancode.craftconomy3.tools.events.canary.CanaryEventManager;
import com.greatmancode.craftconomy3.tools.events.interfaces.EventHandler;
import com.greatmancode.craftconomy3.tools.events.interfaces.Listener;
import com.greatmancode.craftconomy3.tools.events.interfaces.ServerEventManager;
import com.greatmancode.craftconomy3.tools.events.sponge.SpongeEventManager;
import com.greatmancode.craftconomy3.tools.events.unittest.UnitTestEventManager;
import com.greatmancode.craftconomy3.tools.interfaces.Common;
import com.greatmancode.craftconomy3.tools.interfaces.caller.ServerCaller;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class EventManager {
    private Map<String, ListenerRegistration> eventList = new HashMap<String, ListenerRegistration>();
    private static EventManager instance;
    private ServerEventManager eventManager;
    private ServerCaller serverCaller;

    public EventManager(ServerCaller serverCaller) {
        instance = this;
        this.serverCaller = serverCaller;
        if (serverCaller instanceof BukkitServerCaller) {
            this.eventManager = new BukkitEventManager();
        } else if (serverCaller instanceof CanaryServerCaller) {
            this.eventManager = new CanaryEventManager();
        } else if (serverCaller instanceof UnitTestServerCaller) {
            this.eventManager = new UnitTestEventManager();
        } else if (serverCaller instanceof SpongeServerCaller) {
            this.eventManager = new SpongeEventManager();
        }
    }

    public static EventManager getInstance() {
        return instance;
    }

    public Event callEvent(Event event) {
        if (this.eventList.containsKey(event.getClass().getName())) {
            this.eventList.get(event.getClass().getName()).callEvent(event);
        }
        return event;
    }

    protected void registerEvents(Listener listener) {
        if (listener != null) {
            this.internalRegisterEvents(listener);
        }
    }

    public void registerEvents(Common commonInterface, Listener listener) {
        if (commonInterface != null && listener != null) {
            this.internalRegisterEvents(listener);
        }
    }

    private void internalRegisterEvents(Listener listener) {
        if (listener != null) {
            Method[] methods;
            for (Method method : methods = listener.getClass().getMethods()) {
                Class<?>[] parameters;
                if (method.getAnnotation(EventHandler.class) == null || (parameters = method.getParameterTypes()).length != 1) continue;
                for (Class<?> parameter : parameters) {
                    if (!Event.class.isAssignableFrom(parameter)) continue;
                    this.eventManager.eventRegistered(parameter.getName(), this.serverCaller);
                    if (this.eventList.containsKey(parameter.getName())) {
                        this.eventList.get(parameter.getName()).addListener(listener, method);
                        continue;
                    }
                    ListenerRegistration registration = new ListenerRegistration();
                    registration.addListener(listener, method);
                    this.eventList.put(parameter.getName(), registration);
                }
            }
        }
    }
}

