/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.commands;

import com.greatmancode.craftconomy3.tools.commands.CommandHandler;
import com.greatmancode.craftconomy3.tools.commands.interfaces.Command;
import com.greatmancode.craftconomy3.tools.commands.interfaces.CommandExecutor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SubCommand
implements Command {
    private Map<String, Command> commandList = new HashMap<String, Command>();
    private CommandHandler commandHandler;
    private SubCommand parent;
    private String name;
    private int level;

    public SubCommand(String name, CommandHandler commandHandler, SubCommand parent, int level) {
        this.name = name;
        this.commandHandler = commandHandler;
        this.parent = parent;
        this.level = level;
    }

    public SubCommand(String name, CommandHandler commandHandler, SubCommand parent) {
        this(name, commandHandler, parent, 0);
    }

    public void addCommand(String name, Command command) {
        this.commandList.put(name, command);
        if (command instanceof CommandExecutor) {
            this.commandHandler.getServerCaller().registerPermission(((CommandExecutor)command).getPermissionNode());
        }
    }

    public boolean commandExist(String name) {
        return this.commandList.containsKey(name);
    }

    public void execute(String command, String sender, String[] args) {
        if (this.level <= this.commandHandler.getLevel()) {
            if (this.commandExist(command)) {
                Command entry = this.commandList.get(command);
                if (entry instanceof CommandExecutor) {
                    CommandExecutor cmd = (CommandExecutor)entry;
                    if (this.commandHandler.getServerCaller().getPlayerCaller().checkPermission(sender, cmd.getPermissionNode())) {
                        if (cmd.playerOnly() && sender.equalsIgnoreCase("console")) {
                            this.commandHandler.getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_RED}}Only players can do this command!");
                            return;
                        }
                        if (args.length >= cmd.minArgs() && args.length <= cmd.maxArgs()) {
                            cmd.execute(sender, args);
                        } else {
                            this.commandHandler.getServerCaller().getPlayerCaller().sendMessage(sender, cmd.help());
                        }
                    } else {
                        this.commandHandler.getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_RED}}Permission denied!");
                    }
                } else if (entry instanceof SubCommand) {
                    SubCommand subCommand = (SubCommand)entry;
                    String subSubCommand = "";
                    if (args.length != 0) {
                        subSubCommand = args[0];
                    }
                    if (subCommand.commandExist(subSubCommand)) {
                        String[] newArgs;
                        if (args.length == 0) {
                            newArgs = args;
                        } else {
                            newArgs = new String[args.length - 1];
                            System.arraycopy(args, 1, newArgs, 0, args.length - 1);
                        }
                        ((SubCommand)entry).execute(subSubCommand, sender, newArgs);
                    }
                }
            } else {
                this.commandHandler.getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_GREEN}}========= {{WHITE}}Help {{DARK_GREEN}}========");
                for (Map.Entry<String, Command> iteratorEntry : this.commandList.entrySet()) {
                    Command commandEntry = iteratorEntry.getValue();
                    if (commandEntry instanceof CommandExecutor) {
                        CommandExecutor cmd = (CommandExecutor)iteratorEntry.getValue();
                        if (!this.commandHandler.getServerCaller().getPlayerCaller().checkPermission(sender, cmd.getPermissionNode())) continue;
                        this.commandHandler.getServerCaller().getPlayerCaller().sendMessage(sender, cmd.help());
                        continue;
                    }
                    SubCommand subCmd = (SubCommand)commandEntry;
                    String subCommandResult = "";
                    while (subCmd.parent != null) {
                        subCommandResult = subCmd.parent.name + "" + subCommandResult;
                    }
                    subCommandResult = "/" + subCommandResult + " " + subCmd.name;
                    this.commandHandler.getServerCaller().getPlayerCaller().sendMessage(sender, subCommandResult);
                }
            }
        } else {
            this.commandHandler.getServerCaller().getPlayerCaller().sendMessage(sender, this.commandHandler.getWrongLevelMsg());
        }
    }

    public String getSubCommandList() {
        return Arrays.toString(this.commandList.keySet().toArray());
    }
}

