/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.commands;

import com.greatmancode.craftconomy3.tools.caller.bukkit.BukkitServerCaller;
import com.greatmancode.craftconomy3.tools.caller.canary.CanaryServerCaller;
import com.greatmancode.craftconomy3.tools.caller.sponge.SpongeServerCaller;
import com.greatmancode.craftconomy3.tools.commands.SubCommand;
import com.greatmancode.craftconomy3.tools.commands.bukkit.BukkitCommandReceiver;
import com.greatmancode.craftconomy3.tools.commands.canary.CanaryCommandReceiver;
import com.greatmancode.craftconomy3.tools.commands.interfaces.CommandReceiver;
import com.greatmancode.craftconomy3.tools.commands.sponge.SpongeCommandReceiver;
import com.greatmancode.craftconomy3.tools.interfaces.caller.ServerCaller;
import java.util.HashMap;
import java.util.Map;

public class CommandHandler {
    private ServerCaller serverCaller;
    private CommandReceiver commandReceiver;
    private Map<String, SubCommand> commandList = new HashMap<String, SubCommand>();
    private int currentLevel = 0;
    private String wrongLevelMsg = "Wrong level!";

    public CommandHandler(ServerCaller serverCaller) {
        this.serverCaller = serverCaller;
        if (this.serverCaller instanceof BukkitServerCaller) {
            this.commandReceiver = new BukkitCommandReceiver(this);
        } else if (this.serverCaller instanceof CanaryServerCaller) {
            this.commandReceiver = new CanaryCommandReceiver(this);
        } else if (this.serverCaller instanceof SpongeServerCaller) {
            this.commandReceiver = new SpongeCommandReceiver(this);
        }
    }

    public ServerCaller getServerCaller() {
        return this.serverCaller;
    }

    public void setLevel(int level) {
        this.currentLevel = level;
    }

    public int getLevel() {
        return this.currentLevel;
    }

    public String getWrongLevelMsg() {
        return this.wrongLevelMsg;
    }

    public void setWrongLevelMsg(String msg) {
        this.wrongLevelMsg = msg;
    }

    public CommandHandler registerMainCommand(String name, SubCommand subCommand) {
        this.commandList.put(name, subCommand);
        this.serverCaller.addCommand(name, "", this.commandReceiver);
        return this;
    }

    public SubCommand getCommand(String name) {
        return this.commandList.get(name);
    }
}

